/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.packages.dependencies;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.equinox.p2.cudf.metadata.InstallableUnit;
import org.eclipse.equinox.p2.cudf.solver.OptimizationFunction;
import org.nuxeo.connect.data.DownloadablePackage;
import org.nuxeo.connect.packages.PackageManager;
import org.nuxeo.connect.packages.dependencies.DependencyException;
import org.nuxeo.connect.packages.dependencies.DependencyResolution;
import org.nuxeo.connect.packages.dependencies.NuxeoCUDFPackage;
import org.nuxeo.connect.packages.dependencies.TargetPlatformFilterHelper;
import org.nuxeo.connect.update.PackageDependency;
import org.nuxeo.connect.update.Version;
import org.nuxeo.connect.update.VersionRange;

public class CUDFHelper {
    private static final Log log = LogFactory.getLog(CUDFHelper.class);
    public static final String newLine = System.getProperty("line.separator");
    protected PackageManager pm;
    protected Map<String, Map<Version, NuxeoCUDFPackage>> nuxeo2CUDFMap = new HashMap<String, Map<Version, NuxeoCUDFPackage>>();
    protected Map<String, NuxeoCUDFPackage> CUDF2NuxeoMap = new HashMap<String, NuxeoCUDFPackage>();
    private String targetPlatform;

    public CUDFHelper(PackageManager pm) {
        this.pm = pm;
    }

    public void initMapping() {
        this.nuxeo2CUDFMap.clear();
        this.CUDF2NuxeoMap.clear();
        List<DownloadablePackage> allPackages = this.getAllPackages();
        for (DownloadablePackage pkg : allPackages) {
            if (this.targetPlatform != null && !pkg.isLocal() && !TargetPlatformFilterHelper.isCompatibleWithTargetPlatform(pkg, this.targetPlatform)) continue;
            NuxeoCUDFPackage nuxeoCUDFPackage = new NuxeoCUDFPackage(pkg);
            Map<Version, NuxeoCUDFPackage> pkgVersions = this.nuxeo2CUDFMap.get(nuxeoCUDFPackage.getCUDFName());
            if (pkgVersions == null) {
                pkgVersions = new TreeMap<Version, NuxeoCUDFPackage>();
                this.nuxeo2CUDFMap.put(nuxeoCUDFPackage.getCUDFName(), pkgVersions);
            }
            pkgVersions.put(nuxeoCUDFPackage.getNuxeoVersion(), nuxeoCUDFPackage);
        }
        for (String key : this.nuxeo2CUDFMap.keySet()) {
            Map<Version, NuxeoCUDFPackage> pkgVersions = this.nuxeo2CUDFMap.get(key);
            int posInt = 1;
            for (Version version : pkgVersions.keySet()) {
                NuxeoCUDFPackage pkg = pkgVersions.get(version);
                pkg.setCUDFVersion(posInt++);
                this.CUDF2NuxeoMap.put(pkg.getCUDFName() + "-" + pkg.getCUDFVersion(), pkg);
            }
        }
        if (log.isDebugEnabled()) {
            MapUtils.verbosePrint((PrintStream)System.out, (Object)"nuxeo2CUDFMap", this.nuxeo2CUDFMap);
            MapUtils.verbosePrint((PrintStream)System.out, (Object)"CUDF2NuxeoMap", this.CUDF2NuxeoMap);
        }
    }

    protected List<DownloadablePackage> getAllPackages() {
        return this.pm.listAllPackages();
    }

    public NuxeoCUDFPackage getCUDFPackage(String cudfKey) {
        return this.CUDF2NuxeoMap.get(cudfKey);
    }

    public Map<Version, NuxeoCUDFPackage> getCUDFPackages(String cudfName) {
        return this.nuxeo2CUDFMap.get(cudfName);
    }

    public NuxeoCUDFPackage getInstalledCUDFPackage(String pkgName) {
        Map<Version, NuxeoCUDFPackage> packages = this.getCUDFPackages(pkgName);
        if (packages != null) {
            for (NuxeoCUDFPackage pkg : packages.values()) {
                if (!pkg.isInstalled()) continue;
                return pkg;
            }
        }
        return null;
    }

    public String getCUDFFile() throws DependencyException {
        this.initMapping();
        StringBuilder sb = new StringBuilder();
        for (String cudfKey : this.CUDF2NuxeoMap.keySet()) {
            NuxeoCUDFPackage cudfPackage = this.CUDF2NuxeoMap.get(cudfKey);
            sb.append(cudfPackage.getCUDFStanza());
            sb.append("depends: " + this.formatCUDF(cudfPackage.getDependencies(), false) + newLine);
            String conflictsFormatted = this.formatCUDF(cudfPackage.getConflicts(), false);
            conflictsFormatted = conflictsFormatted + (conflictsFormatted.trim().length() > 0 ? ", " : "") + cudfPackage.getCUDFName() + " != " + cudfPackage.getCUDFVersion();
            sb.append("conflicts: " + conflictsFormatted + newLine);
            sb.append("provides: " + this.formatCUDF(cudfPackage.getProvides(), false) + newLine);
            sb.append(System.getProperty("line.separator"));
        }
        return sb.toString();
    }

    private String formatCUDF(PackageDependency[] dependencies, boolean failOnError) throws DependencyException {
        if (dependencies == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (PackageDependency packageDependency : dependencies) {
            int cudfMaxVersion;
            NuxeoCUDFPackage cudfPackage;
            int cudfMinVersion;
            String cudfName = NuxeoCUDFPackage.getCUDFName(packageDependency);
            Map<Version, NuxeoCUDFPackage> versionsMap = this.nuxeo2CUDFMap.get(cudfName);
            if (versionsMap == null) {
                String errMsg = "Missing mapping for " + packageDependency + " with target platform " + this.targetPlatform;
                if (failOnError) {
                    throw new DependencyException(errMsg);
                }
                log.warn((Object)errMsg);
                continue;
            }
            VersionRange versionRange = packageDependency.getVersionRange();
            if (versionRange.getMinVersion() == null) {
                cudfMinVersion = -1;
            } else {
                cudfPackage = versionsMap.get(versionRange.getMinVersion());
                int n = cudfMinVersion = cudfPackage == null ? -1 : cudfPackage.getCUDFVersion();
            }
            if (versionRange.getMaxVersion() == null) {
                cudfMaxVersion = -1;
            } else {
                cudfPackage = versionsMap.get(versionRange.getMaxVersion());
                int n = cudfMaxVersion = cudfPackage == null ? -1 : cudfPackage.getCUDFVersion();
            }
            if (cudfMinVersion == cudfMaxVersion) {
                if (cudfMinVersion == -1) {
                    sb.append(cudfName + ", ");
                    continue;
                }
                sb.append(cudfName + " = " + cudfMinVersion + ", ");
                continue;
            }
            if (cudfMinVersion != -1) {
                sb.append(cudfName + " >= " + cudfMinVersion + ", ");
            }
            if (cudfMaxVersion == -1) continue;
            sb.append(cudfName + " <= " + cudfMaxVersion + ", ");
        }
        if (sb.length() > 0) {
            return sb.toString().substring(0, sb.length() - 2);
        }
        return "";
    }

    public String getCUDFFile(PackageDependency[] pkgInstall, PackageDependency[] pkgRemove, PackageDependency[] pkgUpgrade) throws DependencyException {
        StringBuilder sb = new StringBuilder(this.getCUDFFile());
        sb.append("request: " + newLine);
        sb.append("install: " + this.formatCUDF(pkgInstall, true) + newLine);
        sb.append("remove: " + this.formatCUDF(pkgRemove, true) + newLine);
        sb.append("upgrade: " + this.formatCUDF(pkgUpgrade, true) + newLine);
        return sb.toString();
    }

    public DependencyResolution buildResolution(Collection<InstallableUnit> solution, Map<OptimizationFunction.Criteria, List<String>> details) throws DependencyException {
        if (solution == null) {
            throw new DependencyException("No solution found.");
        }
        log.debug((Object)"\nP2CUDF resolution details: ");
        for (OptimizationFunction.Criteria criteria : OptimizationFunction.Criteria.values()) {
            if (details.get(criteria).isEmpty()) continue;
            log.debug((Object)(criteria.label + ": " + details.get(criteria)));
        }
        DependencyResolution res = new DependencyResolution();
        this.completeResolution(res, details, solution);
        if (res.isFailed()) {
            throw new DependencyException(res.failedMessage);
        }
        res.markAsSuccess();
        this.pm.order(res);
        return res;
    }

    private void completeResolution(DependencyResolution res, Map<OptimizationFunction.Criteria, List<String>> details, Collection<InstallableUnit> solution) {
        for (String pkgName : details.get(OptimizationFunction.Criteria.REMOVED)) {
            NuxeoCUDFPackage pkg = this.getInstalledCUDFPackage(pkgName);
            if (pkg == null) continue;
            res.markPackageForRemoval(pkg.getNuxeoName(), pkg.getNuxeoVersion(), true);
        }
        ArrayList<InstallableUnit> sortedSolution = new ArrayList<InstallableUnit>(solution);
        Collections.sort(sortedSolution);
        log.debug((Object)("Solution: " + sortedSolution));
        if (log.isTraceEnabled()) {
            log.trace((Object)"P2CUDF printed solution");
            for (InstallableUnit iu : sortedSolution) {
                log.trace((Object)("  package: " + iu.getId()));
                log.trace((Object)("  version: " + iu.getVersion().getMajor()));
                log.trace((Object)("  installed: " + iu.isInstalled()));
            }
        }
        for (InstallableUnit iu : sortedSolution) {
            NuxeoCUDFPackage pkg = this.getCUDFPackage(iu.getId() + "-" + iu.getVersion());
            if (pkg == null) {
                log.warn((Object)("Couldn't find " + pkg));
                continue;
            }
            if (!details.get(OptimizationFunction.Criteria.NEW).contains(iu.getId()) && !details.get(OptimizationFunction.Criteria.VERSION_CHANGED).contains(iu.getId()) || res.addPackage(pkg.getNuxeoName(), pkg.getNuxeoVersion(), true)) continue;
            log.error((Object)("Failed to add " + pkg));
        }
    }

    public void setTargetPlatform(String targetPlatform) {
        this.targetPlatform = targetPlatform;
    }
}

