/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.connector.http;

import java.io.IOException;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Fail;
import org.assertj.core.api.ListAssert;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.nuxeo.connect.NuxeoConnectClient;
import org.nuxeo.connect.connector.ConnectClientVersionMismatchError;
import org.nuxeo.connect.connector.ConnectSecurityError;
import org.nuxeo.connect.connector.ConnectServerError;
import org.nuxeo.connect.connector.http.ConnectHttpConnector;
import org.nuxeo.connect.data.DownloadingPackage;
import org.nuxeo.connect.data.SubscriptionStatus;
import org.nuxeo.connect.update.PackageType;

public class TestConnectHttpConnector {
    private Server server;
    private static final String BASE_RESOURCE = "jetty-test";
    private static final String HOST = "localhost";
    private static final int PORT = 17488;
    private final String testTargetPlatform = "server-10.3";
    private ConnectHttpConnector httpConnector;

    @Before
    public void setUp() throws Exception {
        this.server = new Server();
        ServerConnector connector = new ServerConnector(this.server);
        connector.setHost(HOST);
        connector.setPort(17488);
        connector.setIdleTimeout(60000L);
        this.server.addConnector((Connector)connector);
        GzipHandler gzipHandler = new GzipHandler();
        gzipHandler.setMinGzipSize(0);
        gzipHandler.setHandler((Handler)new CustomTestRequestHandler());
        this.server.setHandler((Handler)gzipHandler);
        this.server.start();
        this.httpConnector = new ConnectHttpConnector();
        this.httpConnector.overrideUrl = "http://localhost:17488/jetty-test/";
    }

    @After
    public void tearDown() throws Exception {
        try {
            this.httpConnector.flushCache();
            for (DownloadingPackage downloadingPackage : NuxeoConnectClient.getDownloadManager().listDownloadingPackages()) {
                NuxeoConnectClient.getDownloadManager().removeDownloadingPackage(downloadingPackage.getId());
            }
        }
        finally {
            this.server.stop();
            this.server.destroy();
        }
    }

    @Test
    public void it_should_handle_OK_response_for_connect_status() throws ConnectServerError {
        this.getCustomHandler().setExpectedTargetSuffix("status");
        SubscriptionStatus connectStatus = this.httpConnector.getConnectStatus();
        Assertions.assertThat((Object)connectStatus).isNotNull();
    }

    @Test
    public void it_should_handle_OK_response_for_get_downloads() throws ConnectServerError {
        String typeStr = String.valueOf(PackageType.ADDON);
        this.getCustomHandler().setExpectedTargetSuffix("getDownloads/" + typeStr);
        this.getCustomHandler().setExpectedJSONResponse("[{\"name\" : \"test1\"}, {\"name\" : \"test2\"}]");
        List downloads = this.httpConnector.getDownloads(PackageType.ADDON, "server-10.3");
        ((ListAssert)Assertions.assertThat((List)downloads).isNotNull()).hasSize(2);
    }

    @Test
    public void it_should_handle_OK_response_for_get_download() throws ConnectServerError {
        String pkgName = "test1";
        String pkgVersion = "1.0.0";
        String pkgId = pkgName + "-" + pkgVersion;
        this.getCustomHandler().setExpectedTargetSuffix("getDownload/" + pkgId);
        this.getCustomHandler().setExpectedJSONResponse("{\"name\" : \"" + pkgName + "\", \"version\" : \"" + pkgVersion + "\"}");
        DownloadingPackage download = this.httpConnector.getDownload(pkgId);
        Assertions.assertThat((Object)download).isNotNull();
    }

    @Test
    public void it_should_handle_NOT_FOUND_response_for_connect_status() throws ConnectServerError {
        this.getCustomHandler().setExpectedTargetSuffix("status");
        this.getCustomHandler().setExpectedResponseStatus(404);
        SubscriptionStatus connectStatus = this.httpConnector.getConnectStatus();
        Assertions.assertThat((Object)connectStatus).isNotNull();
    }

    @Test
    public void it_should_handle_NOT_FOUND_response_for_get_downloads() throws ConnectServerError {
        String typeStr = String.valueOf(PackageType.ADDON);
        this.getCustomHandler().setExpectedTargetSuffix("getDownloads/" + typeStr);
        this.getCustomHandler().setExpectedResponseStatus(404);
        this.getCustomHandler().setExpectedJSONResponse("[{\"name\" : \"test1\"}, {\"name\" : \"test2\"}]");
        List downloads = this.httpConnector.getDownloads(PackageType.ADDON, "server-10.3");
        ((ListAssert)Assertions.assertThat((List)downloads).isNotNull()).hasSize(2);
    }

    @Test
    public void it_should_handle_NOT_FOUND_response_for_get_download() throws ConnectServerError {
        String pkgName = "test1";
        String pkgVersion = "1.0.0";
        String pkgId = pkgName + "-" + pkgVersion;
        this.getCustomHandler().setExpectedTargetSuffix("getDownload/" + pkgId);
        this.getCustomHandler().setExpectedResponseStatus(404);
        this.getCustomHandler().setExpectedJSONResponse("{\"name\" : \"" + pkgName + "\", \"version\" : \"" + pkgVersion + "\"}");
        DownloadingPackage download = this.httpConnector.getDownload(pkgId);
        Assertions.assertThat((Object)download).isNotNull();
    }

    @Test
    public void it_should_handle_NO_CONTENT_response_for_connect_status() {
        this.getCustomHandler().setExpectedTargetSuffix("status");
        this.getCustomHandler().setExpectedResponseStatus(204);
        try {
            this.httpConnector.getConnectStatus();
            Fail.failBecauseExceptionWasNotThrown(ConnectServerError.class);
        }
        catch (ConnectServerError e) {
            Assertions.assertThat((String)e.getMessage()).isEqualTo((Object)"null response from server");
        }
    }

    @Test
    public void it_should_handle_NO_CONTENT_response_for_get_downloads() throws ConnectServerError {
        String typeStr = String.valueOf(PackageType.ADDON);
        this.getCustomHandler().setExpectedTargetSuffix("getDownloads/" + typeStr);
        this.getCustomHandler().setExpectedResponseStatus(204);
        List downloads = this.httpConnector.getDownloads(PackageType.ADDON, "server-10.3");
        ((ListAssert)Assertions.assertThat((List)downloads).isNotNull()).hasSize(0);
    }

    @Test
    public void it_should_handle_NO_CONTENT_response_for_get_download() throws ConnectServerError {
        String pkgName = "test1";
        String pkgVersion = "1.0.0";
        String pkgId = pkgName + "-" + pkgVersion;
        this.getCustomHandler().setExpectedTargetSuffix("getDownload/" + pkgId);
        this.getCustomHandler().setExpectedResponseStatus(204);
        DownloadingPackage download = this.httpConnector.getDownload(pkgId);
        Assertions.assertThat((Object)download).isNull();
    }

    @Test
    public void it_should_handle_UNAUTHORIZED_response() {
        this.getCustomHandler().setExpectedResponseStatus(401);
        this.getCustomHandler().setExpectedTargetSuffix("status");
        try {
            this.httpConnector.getConnectStatus();
            Fail.failBecauseExceptionWasNotThrown(ConnectServerError.class);
        }
        catch (ConnectServerError e) {
            Assertions.assertThat((String)e.getMessage()).isEqualTo((Object)"Connect server refused authentication (returned 401)");
        }
        String typeStr = String.valueOf(PackageType.ADDON);
        this.getCustomHandler().setExpectedTargetSuffix("getDownloads/" + typeStr);
        try {
            this.httpConnector.getDownloads(PackageType.ADDON, "server-10.3");
            Fail.failBecauseExceptionWasNotThrown(ConnectServerError.class);
        }
        catch (ConnectServerError e) {
            Assertions.assertThat((String)e.getMessage()).isEqualTo((Object)"Connect server refused authentication (returned 401)");
        }
        String pkgName = "test1";
        String pkgVersion = "1.0.0";
        String pkgId = pkgName + "-" + pkgVersion;
        this.getCustomHandler().setExpectedTargetSuffix("getDownload/" + pkgId);
        try {
            this.httpConnector.getDownload(pkgId);
            Fail.failBecauseExceptionWasNotThrown(ConnectServerError.class);
        }
        catch (ConnectServerError e) {
            Assertions.assertThat((String)e.getMessage()).isEqualTo((Object)"Connect server refused authentication (returned 401)");
        }
    }

    @Test
    public void it_should_handle_GATEWAY_TIMEOUT_response() {
        this.getCustomHandler().setExpectedResponseStatus(504);
        this.getCustomHandler().setExpectedTargetSuffix("status");
        try {
            this.httpConnector.getConnectStatus();
            Fail.failBecauseExceptionWasNotThrown(ConnectServerError.class);
        }
        catch (ConnectServerError e) {
            Assertions.assertThat((String)e.getMessage()).isEqualTo((Object)"Timeout 504");
        }
        String typeStr = String.valueOf(PackageType.ADDON);
        this.getCustomHandler().setExpectedTargetSuffix("getDownloads/" + typeStr);
        try {
            this.httpConnector.getDownloads(PackageType.ADDON, "server-10.3");
            Fail.failBecauseExceptionWasNotThrown(ConnectServerError.class);
        }
        catch (ConnectServerError e) {
            Assertions.assertThat((String)e.getMessage()).isEqualTo((Object)"Timeout 504");
        }
        String pkgName = "test1";
        String pkgVersion = "1.0.0";
        String pkgId = pkgName + "-" + pkgVersion;
        this.getCustomHandler().setExpectedTargetSuffix("getDownload/" + pkgId);
        try {
            this.httpConnector.getDownload(pkgId);
            Fail.failBecauseExceptionWasNotThrown(ConnectServerError.class);
        }
        catch (ConnectServerError e) {
            Assertions.assertThat((String)e.getMessage()).isEqualTo((Object)"Timeout 504");
        }
    }

    @Test
    public void it_should_handle_REQUEST_TIMEOUT_response() {
        this.getCustomHandler().setExpectedResponseStatus(408);
        this.getCustomHandler().setExpectedTargetSuffix("status");
        try {
            this.httpConnector.getConnectStatus();
            Fail.failBecauseExceptionWasNotThrown(ConnectServerError.class);
        }
        catch (ConnectServerError e) {
            Assertions.assertThat((String)e.getMessage()).isEqualTo((Object)"Timeout 408");
        }
        String typeStr = String.valueOf(PackageType.ADDON);
        this.getCustomHandler().setExpectedTargetSuffix("getDownloads/" + typeStr);
        try {
            this.httpConnector.getDownloads(PackageType.ADDON, "server-10.3");
            Fail.failBecauseExceptionWasNotThrown(ConnectServerError.class);
        }
        catch (ConnectServerError e) {
            Assertions.assertThat((String)e.getMessage()).isEqualTo((Object)"Timeout 408");
        }
        String pkgName = "test1";
        String pkgVersion = "1.0.0";
        String pkgId = pkgName + "-" + pkgVersion;
        this.getCustomHandler().setExpectedTargetSuffix("getDownload/" + pkgId);
        try {
            this.httpConnector.getDownload(pkgId);
            Fail.failBecauseExceptionWasNotThrown(ConnectServerError.class);
        }
        catch (ConnectServerError e) {
            Assertions.assertThat((String)e.getMessage()).isEqualTo((Object)"Timeout 408");
        }
    }

    @Test
    public void it_should_handle_INTERNAL_SERVER_ERROR_response() throws ConnectServerError {
        this.getCustomHandler().setExpectedResponseStatus(500);
        this.getCustomHandler().setExpectedJSONResponse("{\"errorClass\" : \"ConnectSecurityError\", \"message\" : \"server message\"}");
        this.getCustomHandler().setExpectedTargetSuffix("status");
        try {
            this.httpConnector.getConnectStatus();
            Fail.failBecauseExceptionWasNotThrown(ConnectSecurityError.class);
        }
        catch (ConnectSecurityError e) {
            Assertions.assertThat((String)e.getMessage()).isEqualTo((Object)"server message");
        }
        this.getCustomHandler().setExpectedJSONResponse("{\"errorClass\" : \"ConnectClientVersionMismatchError\", \"message\" : \"server message\"}");
        String typeStr = String.valueOf(PackageType.ADDON);
        this.getCustomHandler().setExpectedTargetSuffix("getDownloads/" + typeStr);
        try {
            this.httpConnector.getDownloads(PackageType.ADDON, "server-10.3");
            Fail.failBecauseExceptionWasNotThrown(ConnectClientVersionMismatchError.class);
        }
        catch (ConnectClientVersionMismatchError e) {
            Assertions.assertThat((String)e.getMessage()).isEqualTo((Object)"server message");
        }
        this.getCustomHandler().setExpectedJSONResponse("{\"errorClass\" : \"UnknownError\", \"message\" : \"server message\"}");
        String pkgName = "test1";
        String pkgVersion = "1.0.0";
        String pkgId = pkgName + "-" + pkgVersion;
        this.getCustomHandler().setExpectedTargetSuffix("getDownload/" + pkgId);
        try {
            this.httpConnector.getDownload(pkgId);
            Fail.failBecauseExceptionWasNotThrown(ConnectServerError.class);
        }
        catch (ConnectServerError e) {
            Assertions.assertThat((String)e.getMessage()).isEqualTo((Object)"server message");
        }
        this.getCustomHandler().setExpectedJSONResponse("{malformed JSON");
        this.getCustomHandler().setExpectedTargetSuffix("status");
        try {
            this.httpConnector.getConnectStatus();
            Fail.failBecauseExceptionWasNotThrown(ConnectServerError.class);
        }
        catch (ConnectServerError e) {
            Assertions.assertThat((String)e.getMessage()).isEqualTo((Object)"Server returned a code 500");
        }
    }

    private CustomTestRequestHandler getCustomHandler() {
        return (CustomTestRequestHandler)((HandlerWrapper)this.server.getHandler()).getHandler();
    }

    public class CustomTestRequestHandler
    extends AbstractHandler {
        private String expectedTargetSuffix = "";
        private int expectedResponseStatus = 200;
        private String expectedJSONResponse = "{}";
        private boolean expectGzipHeader = true;

        public void setExpectGzipHeader(boolean expectGzipHeader) {
            this.expectGzipHeader = expectGzipHeader;
        }

        public void setExpectedTargetSuffix(String expectedTargetSuffix) {
            this.expectedTargetSuffix = expectedTargetSuffix;
        }

        public void setExpectedResponseStatus(int expectedResponseStatus) {
            this.expectedResponseStatus = expectedResponseStatus;
        }

        public void setExpectedJSONResponse(String expectedJSONResponse) {
            this.expectedJSONResponse = expectedJSONResponse;
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)target.endsWith("/" + this.expectedTargetSuffix)).as("Target url %s should end with %s", new Object[]{target, this.expectedTargetSuffix})).isTrue();
            if (this.expectGzipHeader) {
                Assertions.assertThat((String)request.getHeader("Accept-Encoding")).contains(new CharSequence[]{"gzip"});
            }
            response.setStatus(this.expectedResponseStatus);
            try (ServletOutputStream os = response.getOutputStream();){
                os.print(this.expectedJSONResponse);
            }
        }
    }
}

