/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.connector.http.proxy;

import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.nuxeo.connect.connector.http.ProxyHelper;
import org.nuxeo.connect.connector.http.proxy.ProxyPacResolver;

public class TestProxyPacResolver {
    static final String PAC_FILE_KEY = "nuxeo.test.pac.fake.remote.file";
    ProxyPacResolver solver;

    @BeforeClass
    public static void beforeClass() {
        System.setProperty("org.nuxeo.connect.client.testMode", "true");
    }

    @Before
    public void before() {
        System.clearProperty(PAC_FILE_KEY);
        this.solver = ProxyHelper.pacResolver;
    }

    @Test
    public void testGetSimplePac() {
        this.changePacFile("simple_pac.js");
        String[] proxies = this.solver.findPacProxies("http://www.dimdamdom.fr/page.php");
        Assert.assertEquals((long)1L, (long)proxies.length);
        Assert.assertEquals((Object)"DIRECT", (Object)proxies[0]);
    }

    @Test
    public void testMissingPac() {
        this.changePacFile("");
        String[] proxies = this.solver.findPacProxies("http://www.dimdamdom.fr/page.php");
        Assert.assertNull((Object)proxies);
    }

    @Test
    public void testNuxeocom() {
        this.changePacFile("test1_pac.js");
        String[] proxies = this.solver.findPacProxies("https://www.nuxeo.com");
        Assert.assertEquals((long)1L, (long)proxies.length);
        Assert.assertEquals((Object)"DIRECT", (Object)proxies[0]);
        proxies = this.solver.findPacProxies("http://localhost:8080/nuxeo/");
        Assert.assertEquals((long)1L, (long)proxies.length);
        Assert.assertEquals((Object)"PROXY 127.0.0.1", (Object)proxies[0]);
    }

    @Test
    public void testFunctions() {
        this.changePacFile("test2_pac.js");
        String[] proxies = this.solver.findPacProxies("ftp://www.something.com");
        Assert.assertEquals((long)1L, (long)proxies.length);
        Assert.assertEquals((Object)"DIRECT", (Object)proxies[0]);
        proxies = this.solver.findPacProxies("http://intranet.domain.com/blabla");
        Assert.assertEquals((long)1L, (long)proxies.length);
        Assert.assertEquals((Object)"DIRECT", (Object)proxies[0]);
        proxies = this.solver.findPacProxies("http://abcdomain.com/folder/something");
        Assert.assertEquals((long)1L, (long)proxies.length);
        Assert.assertEquals((Object)"DIRECT", (Object)proxies[0]);
        proxies = this.solver.findPacProxies("http://www.abcdomain.com/blabla");
        Assert.assertEquals((long)1L, (long)proxies.length);
        Assert.assertEquals((Object)"DIRECT", (Object)proxies[0]);
        proxies = this.solver.findPacProxies("http://www.domain.com/blabla");
        Assert.assertEquals((long)2L, (long)proxies.length);
    }

    @Test
    public void testProxyRegex() {
        String[] res = ProxyPacResolver.parseProxyInfos((String)"PROXY 127.0.0.1");
        Assert.assertEquals((Object)"127.0.0.1", (Object)res[0]);
        Assert.assertEquals((Object)"-1", (Object)res[1]);
        res = ProxyPacResolver.parseProxyInfos((String)" PROXY 127.0.0.1:8080");
        Assert.assertEquals((Object)"127.0.0.1", (Object)res[0]);
        Assert.assertEquals((Object)"8080", (Object)res[1]);
        res = ProxyPacResolver.parseProxyInfos((String)" PROXY myproxy.com:0");
        Assert.assertEquals((Object)"myproxy.com", (Object)res[0]);
        Assert.assertEquals((Object)"0", (Object)res[1]);
        res = ProxyPacResolver.parseProxyInfos((String)" PROXY myproxy.com:");
        Assert.assertNull((Object)res[0]);
        Assert.assertNull((Object)res[1]);
        res = ProxyPacResolver.parseProxyInfos((String)" PROXY my43proxy.com");
        Assert.assertEquals((Object)"my43proxy.com", (Object)res[0]);
        Assert.assertEquals((Object)"-1", (Object)res[1]);
    }

    protected void changePacFile(String name) {
        System.setProperty(PAC_FILE_KEY, "test-pac/" + name);
    }
}

