/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.connector.test;

import java.util.List;
import junit.framework.TestCase;
import org.nuxeo.connect.connector.test.ConnectTestConnector;
import org.nuxeo.connect.data.DownloadablePackage;
import org.nuxeo.connect.data.SubscriptionStatus;
import org.nuxeo.connect.identity.LogicalInstanceIdentifier;
import org.nuxeo.connect.update.PackageType;

public class TestFakeConnector
extends TestCase {
    private final String testTargetPlatform = "server-10.3";

    public void testFakeConnector() throws Exception {
        LogicalInstanceIdentifier CLID = new LogicalInstanceIdentifier("toto--titi", "myInstance");
        CLID.save();
        ConnectTestConnector connector = new ConnectTestConnector();
        connector.flushCache();
        SubscriptionStatus status = connector.getConnectStatus();
        TestFakeConnector.assertNotNull((Object)status);
        TestFakeConnector.assertEquals((String)"active", (String)status.getContractStatus());
        List packages = connector.getDownloads(PackageType.HOT_FIX, "server-10.3");
        TestFakeConnector.assertNotNull((Object)packages);
        TestFakeConnector.assertEquals((int)2, (int)packages.size());
        TestFakeConnector.assertEquals((String)"hot fix 1", (String)((DownloadablePackage)packages.get(0)).getTitle());
        TestFakeConnector.assertEquals((Object)PackageType.HOT_FIX, (Object)((DownloadablePackage)packages.get(0)).getType());
        packages = connector.getDownloads(PackageType.STUDIO, "server-10.3");
        TestFakeConnector.assertNotNull((Object)packages);
        TestFakeConnector.assertEquals((int)1, (int)packages.size());
        TestFakeConnector.assertEquals((String)"my project", (String)((DownloadablePackage)packages.get(0)).getTitle());
        TestFakeConnector.assertEquals((Object)PackageType.STUDIO, (Object)((DownloadablePackage)packages.get(0)).getType());
    }
}

