/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.data;

import java.util.Arrays;
import java.util.Collections;
import org.apache.commons.lang3.mutable.MutableObject;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.nuxeo.connect.data.PackageDescriptor;
import org.nuxeo.connect.update.PackageDependency;

public class TestPackageDescriptor {
    @After
    public void clearSystemProperty() {
        System.clearProperty("nuxeo.cap.target.platform.compat");
    }

    @Test
    public void testSystemProperty() {
        MutableObject pd = new MutableObject();
        String[] targets = PackageDescriptor.fixTargetPlatforms((String)"foo", (String[])new String[]{"cap-123"}, (MutableObject)pd);
        Assert.assertEquals(Arrays.asList("cap-123", "server-123"), Arrays.asList(targets));
        PackageDependency[] packageDependencies = (PackageDependency[])pd.getValue();
        Assert.assertEquals((long)1L, (long)packageDependencies.length);
        Assert.assertEquals((Object)"nuxeo-jsf-ui", (Object)packageDependencies[0].toString());
        System.setProperty("nuxeo.cap.target.platform.compat", "false");
        pd = new MutableObject();
        targets = PackageDescriptor.fixTargetPlatforms((String)"foo", (String[])new String[]{"cap-123"}, (MutableObject)pd);
        Assert.assertEquals(Arrays.asList("cap-123"), Arrays.asList(targets));
        packageDependencies = (PackageDependency[])pd.getValue();
        Assert.assertNull((Object)packageDependencies);
    }

    @Test
    public void testFixTargetPlatforms() {
        MutableObject pd = new MutableObject();
        String[] targets = PackageDescriptor.fixTargetPlatforms((String)"foo", (String[])new String[]{"bar-888"}, (MutableObject)pd);
        Assert.assertEquals(Collections.singletonList("bar-888"), Arrays.asList(targets));
        PackageDependency[] packageDependencies = (PackageDependency[])pd.getValue();
        Assert.assertNull((Object)packageDependencies);
        targets = PackageDescriptor.fixTargetPlatforms((String)"foo", (String[])new String[]{"cap-123"}, (MutableObject)pd);
        Assert.assertEquals(Arrays.asList("cap-123", "server-123"), Arrays.asList(targets));
        packageDependencies = (PackageDependency[])pd.getValue();
        Assert.assertEquals((long)1L, (long)packageDependencies.length);
        Assert.assertEquals((Object)"nuxeo-jsf-ui", (Object)packageDependencies[0].toString());
        targets = PackageDescriptor.fixTargetPlatforms((String)"foo", (String[])new String[]{"bar-888", "cap-123"}, (MutableObject)pd);
        Assert.assertEquals(Arrays.asList("bar-888", "cap-123", "server-123"), Arrays.asList(targets));
        packageDependencies = (PackageDependency[])pd.getValue();
        Assert.assertEquals((long)1L, (long)packageDependencies.length);
        Assert.assertEquals((Object)"nuxeo-jsf-ui", (Object)packageDependencies[0].toString());
        targets = PackageDescriptor.fixTargetPlatforms((String)"foo", (String[])new String[]{"bar-888", "cap-123", "cap-456"}, (MutableObject)pd);
        Assert.assertEquals(Arrays.asList("bar-888", "cap-123", "cap-456", "server-123", "server-456"), Arrays.asList(targets));
        packageDependencies = (PackageDependency[])pd.getValue();
        Assert.assertEquals((long)1L, (long)packageDependencies.length);
        Assert.assertEquals((Object)"nuxeo-jsf-ui", (Object)packageDependencies[0].toString());
        targets = PackageDescriptor.fixTargetPlatforms((String)"foo", (String[])new String[]{"bar-888", "cap-123", "cap-456", "server-123"}, (MutableObject)pd);
        Assert.assertEquals(Arrays.asList("bar-888", "cap-123", "cap-456", "server-123", "server-456"), Arrays.asList(targets));
        packageDependencies = (PackageDependency[])pd.getValue();
        Assert.assertEquals((long)1L, (long)packageDependencies.length);
        Assert.assertEquals((Object)"nuxeo-jsf-ui", (Object)packageDependencies[0].toString());
        targets = PackageDescriptor.fixTargetPlatforms((String)"nuxeo-jsf-ui", (String[])new String[]{"bar-888", "cap-123"}, (MutableObject)pd);
        Assert.assertEquals(Arrays.asList("bar-888", "cap-123"), Arrays.asList(targets));
        packageDependencies = (PackageDependency[])pd.getValue();
        Assert.assertNull((Object)packageDependencies);
    }
}

