/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.packages.dependencies;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.eclipse.equinox.p2.cudf.Parser;
import org.eclipse.equinox.p2.cudf.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.cudf.metadata.IRequiredCapability;
import org.eclipse.equinox.p2.cudf.metadata.InstallableUnit;
import org.eclipse.equinox.p2.cudf.metadata.NotRequirement;
import org.eclipse.equinox.p2.cudf.metadata.RequiredCapability;
import org.eclipse.equinox.p2.cudf.metadata.Version;
import org.eclipse.equinox.p2.cudf.metadata.VersionRange;
import org.eclipse.equinox.p2.cudf.solver.ProfileChangeRequest;
import org.eclipse.equinox.p2.cudf.solver.SimplePlanner;
import org.eclipse.equinox.p2.cudf.solver.SolverConfiguration;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.nuxeo.connect.data.DownloadablePackage;
import org.nuxeo.connect.packages.PackageSource;
import org.nuxeo.connect.packages.dependencies.CUDFHelper;
import org.nuxeo.connect.pm.tests.AbstractPackageManagerTestCase;
import org.nuxeo.connect.pm.tests.DummyPackageSource;

public class CUDFHelperTest
extends AbstractPackageManagerTestCase {
    private CUDFHelper cudfHelper;
    private ProfileChangeRequest pcr;
    private ProfileChangeRequest pcr2;
    private ProfileChangeRequest pcrRemove;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        List<DownloadablePackage> local = CUDFHelperTest.getDownloads("local3.json");
        List<DownloadablePackage> remote = CUDFHelperTest.getDownloads("remote3.json");
        this.pm.registerSource((PackageSource)new DummyPackageSource(local, "local3"), true);
        this.pm.registerSource((PackageSource)new DummyPackageSource(remote, "remote3"), false);
        this.cudfHelper = new CUDFHelper(this.pm);
        this.cudfHelper.setAllowSNAPSHOT(true);
        this.pcr = new Parser().parse((InputStream)new AddSpaceInputStream(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("test-data/request.cudf")));
        this.pcr2 = new Parser().parse((InputStream)new AddSpaceInputStream(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("test-data/request2.cudf")));
        this.pcrRemove = new Parser().parse((InputStream)new AddSpaceInputStream(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("test-data/requestRemove.cudf")));
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testInitMapping() throws Exception {
        this.cudfHelper.initMapping();
        CUDFHelperTest.assertNotNull((Object)this.cudfHelper.getCUDFFile());
        CUDFHelperTest.assertNull((String)"nuxeo-dm packages should be ignored (not involved by request)", (Object)this.cudfHelper.getCUDFPackage("nuxeo-dm-1"));
        CUDFHelperTest.assertEquals((String)"First nuxeo-cmf package should be 5.5.0", (String)"5.5.0", (String)this.cudfHelper.getCUDFPackage("nuxeo-cmf-1").getNuxeoVersion().toString());
        CUDFHelperTest.assertEquals((String)"Second nuxeo-cmf package should be 5.6.0-SNAPSHOT", (String)"5.6.0-SNAPSHOT", (String)this.cudfHelper.getCUDFPackage("nuxeo-cmf-2").getNuxeoVersion().toString());
        CUDFHelperTest.assertEquals((String)"Third nuxeo-cmf package should be 5.6.0", (String)"5.6.0", (String)this.cudfHelper.getCUDFPackage("nuxeo-cmf-3").getNuxeoVersion().toString());
        CUDFHelperTest.assertEquals((String)"There must be one nuxeo-content-browser package", (int)1, (int)this.cudfHelper.getCUDFPackages("nuxeo-content-browser").size());
        CUDFHelperTest.assertEquals((String)"There must be one nuxeo-content-browser*cmf package", (int)1, (int)this.cudfHelper.getCUDFPackages("nuxeo-content-browser*cmf").size());
    }

    @Test
    public void testGetCUDFFile() throws Exception {
        Map refMap;
        Map genMap;
        this.cudfHelper.initMapping();
        String cudfFile = this.cudfHelper.getCUDFFile();
        log.debug((Object)cudfFile);
        try (BufferedReader gen = new BufferedReader(new StringReader(cudfFile));){
            genMap = this.cudfHelper.parseCUDFFile(gen);
        }
        try (BufferedReader ref = new BufferedReader(new InputStreamReader(CUDFHelperTest.class.getClassLoader().getResourceAsStream("test-data/universe.cudf")));){
            refMap = this.cudfHelper.parseCUDFFile(ref);
        }
        CUDFHelperTest.assertEquals((String)"Generated CUDF universe different than the reference", refMap.keySet(), genMap.keySet());
        CUDFHelperTest.assertEquals((String)"Generated CUDF universe different than the reference", new TreeSet(refMap.values()), new TreeSet(genMap.values()));
    }

    private InstallableUnit getIU(String id) {
        for (InstallableUnit iu : this.pcr.getInitialState()) {
            if (!id.equals(iu.getId())) continue;
            return iu;
        }
        CUDFHelperTest.fail((String)("Can't find: " + id));
        return null;
    }

    private void assertNotRequirement(IRequiredCapability asserted, IRequiredCapability[] reqs) {
        for (int i = 0; i < reqs.length; ++i) {
            if (!asserted.getName().equals(reqs[i].getName()) || !asserted.getRange().equals((Object)reqs[i].getRange()) || asserted.getArity() != reqs[i].getArity() || asserted.isNegation() != reqs[i].isNegation()) continue;
            CUDFHelperTest.fail((String)("Requirement not expected:" + asserted));
        }
    }

    private void assertRequirement(String message, IRequiredCapability asserted, IRequiredCapability[] reqs) {
        boolean found = false;
        for (int i = 0; i < reqs.length; ++i) {
            if (!asserted.getName().equals(reqs[i].getName()) || !asserted.getRange().equals((Object)reqs[i].getRange()) || asserted.getArity() != reqs[i].getArity() || asserted.isNegation() != reqs[i].isNegation()) continue;
            found = true;
        }
        CUDFHelperTest.assertEquals((String)message, (boolean)true, (boolean)found);
    }

    private void assertProvide(String message, IProvidedCapability asserted, IProvidedCapability[] caps) {
        boolean found = true;
        for (int i = 0; i < caps.length; ++i) {
            if (!asserted.getName().equals(caps[i].getName())) continue;
            CUDFHelperTest.assertEquals((Object)asserted.getVersion(), (Object)caps[i].getVersion());
        }
        CUDFHelperTest.assertEquals((String)message, (boolean)true, (boolean)found);
    }

    @Test
    public void testP2CUDFParserCheckPackages() {
        InstallableUnit iu = this.getIU("nuxeo-dm");
        this.assertRequirement("nuxeo-dm must conflict with nuxeo-cmf in all versions", (IRequiredCapability)new NotRequirement((IRequiredCapability)new RequiredCapability("nuxeo-cmf", VersionRange.emptyRange)), iu.getRequiredCapabilities());
        CUDFHelperTest.assertEquals((String)"Wrong nuxeo-dm version", (String)"1", (String)iu.getVersion().toString());
        CUDFHelperTest.assertFalse((String)"nuxeo-dm is not installed", (boolean)iu.isInstalled());
        iu = this.getIU("nuxeo-social-collaboration");
        this.assertRequirement("nuxeo-social-collaboration must depend on nuxeo-dm 1", (IRequiredCapability)new RequiredCapability("nuxeo-dm", new VersionRange(new Version(1))), iu.getRequiredCapabilities());
        CUDFHelperTest.assertEquals((String)"Wrong nuxeo-social-collaboration version", (String)"1", (String)iu.getVersion().toString());
        CUDFHelperTest.assertFalse((String)"nuxeo-social-collaboration is not installed", (boolean)iu.isInstalled());
        iu = this.getIU("nuxeo-cmf");
        this.assertRequirement("nuxeo-cmf must conflict with nuxeo-dm in all versions", (IRequiredCapability)new NotRequirement((IRequiredCapability)new RequiredCapability("nuxeo-dm", VersionRange.emptyRange)), iu.getRequiredCapabilities());
        CUDFHelperTest.assertEquals((String)"Wrong nuxeo-cmf version", (String)"1", (String)iu.getVersion().toString());
        CUDFHelperTest.assertTrue((String)"nuxeo-cmf is installed", (boolean)iu.isInstalled());
    }

    @Test
    public void testP2CUDFParserCheckRequest() {
        ArrayList requests = this.pcr.getAllRequests();
        CUDFHelperTest.assertNotNull((Object)requests);
        CUDFHelperTest.assertTrue((requests.size() > 0 ? 1 : 0) != 0);
        SolverConfiguration configuration = new SolverConfiguration("paranoid");
        Object result = new SimplePlanner().getSolutionFor(this.pcr, configuration);
        CUDFHelperTest.assertEquals((String)"[nuxeo-addon 1, nuxeo-dm 1, nuxeo-social-collaboration 1, nuxeo-independent-addon 1]", (String)result.toString());
        configuration = new SolverConfiguration("paranoid");
        result = new SimplePlanner().getSolutionFor(this.pcr2, configuration);
        CUDFHelperTest.assertEquals((String)"[nuxeo-cmf 1, nuxeo-independent-addon 1]", (String)result.toString());
        configuration = new SolverConfiguration("paranoid");
        result = new SimplePlanner().getSolutionFor(this.pcrRemove, configuration);
        CUDFHelperTest.assertEquals((String)"[nuxeo-independent-addon 1]", (String)result.toString());
    }

    public class AddSpaceInputStream
    extends InputStream {
        private InputStream is;
        private int previousByte;

        public AddSpaceInputStream(InputStream resourceAsStream) {
            this.is = resourceAsStream;
        }

        @Override
        public int read() throws IOException {
            if (!this.is.markSupported()) {
                log.error((Object)"Cannot add spaces, that aspect won't be tested.");
                return this.is.read();
            }
            this.is.mark(2);
            int nextByte = this.is.read();
            if (nextByte == 10 && this.previousByte == 58) {
                nextByte = 32;
                this.is.reset();
            }
            this.previousByte = nextByte;
            return nextByte;
        }
    }
}

