/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.packages.dependencies;

import java.util.Arrays;
import java.util.List;
import org.junit.Before;
import org.junit.Test;
import org.nuxeo.connect.data.DownloadablePackage;
import org.nuxeo.connect.packages.PackageSource;
import org.nuxeo.connect.packages.dependencies.DependencyResolution;
import org.nuxeo.connect.pm.tests.AbstractPackageManagerTestCase;
import org.nuxeo.connect.pm.tests.DummyPackageSource;

public class P2CUDFDependencyResolverTest2
extends AbstractPackageManagerTestCase {
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        List<DownloadablePackage> local = P2CUDFDependencyResolverTest2.getDownloads("local6.json");
        List<DownloadablePackage> remote = P2CUDFDependencyResolverTest2.getDownloads("remote4.json");
        this.pm.registerSource((PackageSource)new DummyPackageSource(local, "dummyLocal"), true);
        this.pm.registerSource((PackageSource)new DummyPackageSource(remote, "dummyRemote"), false);
    }

    @Test
    public void testResolve() throws Exception {
        DependencyResolution resolution = this.pm.resolveDependencies(Arrays.asList("DM-5.4.0.1-HF07"), null, null, null);
        P2CUDFDependencyResolverTest2.assertFalse((String)resolution.toString(), (boolean)resolution.isFailed());
        log.info((Object)resolution.toString());
        log.info((Object)("Packages that need to be removed from your instance: resolution.getRemovePackageIds()\n" + resolution.getRemovePackageIds() + "\n"));
        P2CUDFDependencyResolverTest2.assertEquals((String)"There must be no package to remove", (int)0, (int)resolution.getRemovePackageIds().size());
        log.info((Object)("Already installed packages that need to be upgraded: resolution.getUpgradePackageIds()\n" + resolution.getUpgradePackageIds() + "\n"));
        P2CUDFDependencyResolverTest2.assertEquals((String)"There must be no already installed package to upgrade", (int)0, (int)resolution.getUpgradePackageIds().size());
        log.info((Object)("Already downloaded packages that need to be installed: resolution.getLocalToInstallIds()\n" + resolution.getLocalToInstallIds() + "\n"));
        P2CUDFDependencyResolverTest2.assertEquals((String)"There must be one already downloaded package to install", (int)1, (int)resolution.getLocalToInstallIds().size());
        P2CUDFDependencyResolverTest2.assertEquals((String)"DM-5.4.0.1-HF01-1.0.0", (String)((String)resolution.getLocalToInstallIds().get(0)));
        log.info((Object)("New packages that need to be downloaded and installed: resolution.getDownloadPackageIds()\n" + resolution.getDownloadPackageIds() + "\n"));
        P2CUDFDependencyResolverTest2.assertEquals((String)"There must be five packages to download and install", (int)4, (int)resolution.getDownloadPackageIds().size());
        P2CUDFDependencyResolverTest2.assertTrue((boolean)resolution.getDownloadPackageIds().containsAll(Arrays.asList("DM-5.4.0.1-HF04-1.0.0", "DM-5.4.0.1-HF06-1.0.0", "DM-5.4.0.1-HF05-1.0.0", "DM-5.4.0.1-HF07-1.1.0")));
        log.info((Object)("Dependencies that are already installed on your instance and won't be changed: resolution.getUnchangedPackageIds()\n" + resolution.getUnchangedPackageIds() + "\n"));
        P2CUDFDependencyResolverTest2.assertEquals((String)"There must be two unchanged package", (int)2, (int)resolution.getUnchangedPackageIds().size());
        P2CUDFDependencyResolverTest2.assertTrue((boolean)resolution.getUnchangedPackageIds().containsAll(Arrays.asList("DM-5.4.0.1-HF02-1.0.0", "DM-5.4.0.1-HF03-1.0.0")));
    }
}

