/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.pm.tests;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.json.JSONObject;
import org.nuxeo.connect.DefaultCallbackHolder;
import org.nuxeo.connect.NuxeoConnectClient;
import org.nuxeo.connect.data.AbstractJSONSerializableData;
import org.nuxeo.connect.data.DownloadablePackage;
import org.nuxeo.connect.data.PackageDescriptor;
import org.nuxeo.connect.identity.LogicalInstanceIdentifier;
import org.nuxeo.connect.packages.PackageManager;
import org.nuxeo.connect.packages.PackageManagerImpl;
import org.nuxeo.connect.pm.tests.TestPackageManager;
import org.nuxeo.connect.update.MockPackageUpdateService;
import org.nuxeo.connect.update.PackageUpdateService;

public abstract class AbstractPackageManagerTestCase
extends TestCase {
    protected PackageManager pm;
    protected static Log log = LogFactory.getLog(TestPackageManager.class);
    public static final String TEST_DATA = "test-data/";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static List<String> readLines(InputStream in) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader(in));
            while ((line = reader.readLine()) != null) {
                lines.add(line);
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return lines;
    }

    public void setUp() throws Exception {
        super.setUp();
        System.setProperty("org.nuxeo.connect.client.testMode", "true");
        LogicalInstanceIdentifier.cleanUp();
        this.pm = NuxeoConnectClient.getPackageManager();
        AbstractPackageManagerTestCase.assertNotNull((Object)this.pm);
        ((PackageManagerImpl)this.pm).resetSources();
        ((DefaultCallbackHolder)NuxeoConnectClient.getCallBackHolder()).setUpdateService((PackageUpdateService)new MockPackageUpdateService(this.pm));
    }

    protected static List<DownloadablePackage> getDownloads(String filename) throws IOException, JSONException {
        return AbstractPackageManagerTestCase.getDownloads(filename, false);
    }

    protected static List<DownloadablePackage> getDownloads(String filename, boolean isLocal) throws IOException, JSONException {
        ArrayList<DownloadablePackage> result = new ArrayList<DownloadablePackage>();
        InputStream is = TestPackageManager.class.getClassLoader().getResourceAsStream(TEST_DATA + filename);
        List<String> lines = AbstractPackageManagerTestCase.readLines(is);
        for (String data : lines) {
            PackageDescriptor pkg = (PackageDescriptor)AbstractJSONSerializableData.loadFromJSON(PackageDescriptor.class, (JSONObject)new JSONObject(data));
            if (isLocal) {
                pkg.setLocal(true);
            }
            result.add((DownloadablePackage)pkg);
        }
        return result;
    }

    public AbstractPackageManagerTestCase() {
    }

    public AbstractPackageManagerTestCase(String name) {
        super(name);
    }

    protected void dumpPkgList(String label, List<DownloadablePackage> pkgs) {
        StringBuffer sb = new StringBuffer();
        sb.append(label);
        sb.append("={");
        for (DownloadablePackage pkg : pkgs) {
            sb.append(pkg.getId());
            sb.append(" (");
            sb.append(pkg.getName());
            sb.append("  ");
            sb.append(pkg.getVersion().toString());
            sb.append(") ");
            sb.append(" [");
            sb.append(pkg.getPackageState());
            sb.append("], ");
        }
        sb.append("}");
        log.info((Object)sb.toString());
    }
}

