/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.pm.tests;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.nuxeo.connect.data.DownloadablePackage;
import org.nuxeo.connect.packages.PackageSource;
import org.nuxeo.connect.packages.dependencies.DependencyResolution;
import org.nuxeo.connect.pm.tests.AbstractPackageManagerTestCase;
import org.nuxeo.connect.pm.tests.DummyPackageSource;

public class TestDependencies
extends AbstractPackageManagerTestCase {
    @Override
    public void setUp() throws Exception {
        super.setUp();
        List<DownloadablePackage> local = TestDependencies.getDownloads("local9.json");
        TestDependencies.assertTrue((boolean)CollectionUtils.isNotEmpty(local));
        this.pm.registerSource((PackageSource)new DummyPackageSource(local, "local9"), true);
    }

    public void testVersionResolutionWithDifferentDependencies() throws Exception {
        DependencyResolution depResolution = this.pm.resolveDependencies(Arrays.asList("pkgA"), null, null, null);
        log.info((Object)depResolution.toString());
        TestDependencies.assertTrue((boolean)depResolution.isValidated());
        TestDependencies.assertEquals((int)2, (int)depResolution.getOrderedPackageIdsToInstall().size());
        TestDependencies.assertEquals((String)"pkgB-1.0.1", (String)((String)depResolution.getOrderedPackageIdsToInstall().get(0)));
        TestDependencies.assertEquals((String)"pkgA-1.0.3", (String)((String)depResolution.getOrderedPackageIdsToInstall().get(1)));
    }
}

