/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.pm.tests;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.nuxeo.connect.data.DownloadablePackage;
import org.nuxeo.connect.packages.PackageSource;
import org.nuxeo.connect.packages.dependencies.DependencyResolution;
import org.nuxeo.connect.pm.tests.AbstractPackageManagerTestCase;
import org.nuxeo.connect.pm.tests.DummyPackageSource;

public class TestDowngrade
extends AbstractPackageManagerTestCase {
    @Override
    public void setUp() throws Exception {
        super.setUp();
        List<DownloadablePackage> local = TestDowngrade.getDownloads("local5.json");
        TestDowngrade.assertTrue((boolean)CollectionUtils.isNotEmpty(local));
        this.pm.registerSource((PackageSource)new DummyPackageSource(local, "local5"), true);
    }

    public void testResolutionOrder() throws Exception {
        DependencyResolution depResolution = this.pm.resolveDependencies(Arrays.asList("nuxeo-birt-integration-2.0.0"), null, null, null);
        log.info((Object)depResolution.toString());
        TestDowngrade.assertTrue((boolean)depResolution.isValidated());
        TestDowngrade.assertEquals((int)1, (int)depResolution.getOrderedPackageIdsToInstall().size());
        TestDowngrade.assertEquals((String)"nuxeo-birt-integration-2.0.0", (String)((String)depResolution.getOrderedPackageIdsToInstall().get(0)));
    }
}

