/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.pm.tests;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.nuxeo.connect.data.DownloadablePackage;
import org.nuxeo.connect.packages.PackageSource;
import org.nuxeo.connect.packages.dependencies.DependencyResolution;
import org.nuxeo.connect.pm.tests.AbstractPackageManagerTestCase;
import org.nuxeo.connect.pm.tests.DummyPackageSource;

public class TestExclusions
extends AbstractPackageManagerTestCase {
    protected DummyPackageSource source;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        List<DownloadablePackage> local = TestExclusions.getDownloads("localExclusion.json");
        List<DownloadablePackage> remote = TestExclusions.getDownloads("remoteExclusion.json");
        TestExclusions.assertTrue((boolean)CollectionUtils.isNotEmpty(local));
        TestExclusions.assertTrue((boolean)CollectionUtils.isNotEmpty(remote));
        this.source = new DummyPackageSource(local, "localExclusion");
        this.pm.registerSource((PackageSource)this.source, true);
        this.pm.registerSource((PackageSource)new DummyPackageSource(remote, "remoteExclusion"), false);
    }

    public void testResolutionOrder() throws Exception {
        DependencyResolution depResolution = this.pm.resolveDependencies(Arrays.asList("nuxeo-cmf-5.5.0"), null, null, null);
        log.info((Object)depResolution.toString());
        TestExclusions.assertTrue((boolean)depResolution.isValidated());
        TestExclusions.assertEquals((int)2, (int)depResolution.getLocalPackagesToRemove().size());
        TestExclusions.assertTrue((boolean)depResolution.getLocalPackagesToRemove().containsKey("nuxeo-dm"));
        TestExclusions.assertTrue((boolean)depResolution.getLocalPackagesToRemove().containsKey("nuxeo-content-browser"));
        TestExclusions.assertEquals((int)1, (int)depResolution.getLocalPackagesToUpgrade().size());
        TestExclusions.assertTrue((boolean)depResolution.getLocalPackagesToUpgrade().containsKey("nuxeo-content-browser"));
        List<DownloadablePackage> local2 = TestExclusions.getDownloads("localExclusion2.json");
        this.source.reset(local2);
        depResolution = this.pm.resolveDependencies(Arrays.asList("nuxeo-dm-5.5.0"), null, null, null);
        log.info((Object)depResolution.toString());
        TestExclusions.assertTrue((boolean)depResolution.isValidated());
        TestExclusions.assertEquals((int)2, (int)depResolution.getLocalPackagesToRemove().size());
        TestExclusions.assertTrue((boolean)depResolution.getLocalPackagesToRemove().containsKey("nuxeo-cmf"));
        TestExclusions.assertTrue((boolean)depResolution.getLocalPackagesToRemove().containsKey("nuxeo-content-browser"));
        TestExclusions.assertEquals((int)1, (int)depResolution.getLocalPackagesToUpgrade().size());
        TestExclusions.assertTrue((boolean)depResolution.getLocalPackagesToUpgrade().containsKey("nuxeo-content-browser"));
    }
}

