/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.pm.tests;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.nuxeo.connect.data.DownloadablePackage;
import org.nuxeo.connect.packages.PackageSource;
import org.nuxeo.connect.packages.dependencies.DependencyResolution;
import org.nuxeo.connect.pm.tests.AbstractPackageManagerTestCase;
import org.nuxeo.connect.pm.tests.DummyPackageSource;
import org.nuxeo.connect.update.PackageException;

public class TestInstallOfDeprecatedPkg
extends AbstractPackageManagerTestCase {
    @Override
    public void setUp() throws Exception {
        super.setUp();
        List<DownloadablePackage> local = TestInstallOfDeprecatedPkg.getDownloads("local7.json");
        TestInstallOfDeprecatedPkg.assertTrue((boolean)CollectionUtils.isNotEmpty(local));
        this.pm.registerSource((PackageSource)new DummyPackageSource(local, "local7"), true);
    }

    public void testResolutionOrder() {
        DependencyResolution depResolution = this.pm.resolveDependencies(Arrays.asList("nuxeo-poll"), null, null, null);
        log.info((Object)depResolution.toString());
        TestInstallOfDeprecatedPkg.assertTrue((boolean)depResolution.isValidated());
        TestInstallOfDeprecatedPkg.assertEquals((int)3, (int)depResolution.getOrderedPackageIdsToInstall().size());
        TestInstallOfDeprecatedPkg.assertEquals((String)"nuxeo-jsf-ui-5.6.0-cap", (String)((String)depResolution.getOrderedPackageIdsToInstall().get(0)));
        TestInstallOfDeprecatedPkg.assertEquals((String)"nuxeo-dm-5.6.0", (String)((String)depResolution.getOrderedPackageIdsToInstall().get(1)));
        TestInstallOfDeprecatedPkg.assertEquals((String)"nuxeo-poll-1.0.0", (String)((String)depResolution.getOrderedPackageIdsToInstall().get(2)));
    }

    public void testTargetPlatforms() throws PackageException {
        TestInstallOfDeprecatedPkg.assertTrue((boolean)this.pm.matchesPlatform("nuxeo-birt-integration-2.1.0", "cap-5.5"));
        TestInstallOfDeprecatedPkg.assertFalse((boolean)this.pm.matchesPlatform("nuxeo-birt-integration-2.1.0", "cap-5.6"));
        TestInstallOfDeprecatedPkg.assertTrue((boolean)this.pm.matchesPlatform("nuxeo-platform-user-registration-1.2.1", "Nuxeo CAP 5.6"));
        TestInstallOfDeprecatedPkg.assertTrue((boolean)this.pm.matchesPlatform("nuxeo-flavors-unicolor-1.0.0", "cap-5.5"));
        TestInstallOfDeprecatedPkg.assertTrue((boolean)this.pm.matchesPlatform("nuxeo-flavors-unicolor-1.0.0", "cap-5.5.0-HF00"));
        TestInstallOfDeprecatedPkg.assertTrue((boolean)this.pm.matchesPlatform("nuxeo-flavors-unicolor-1.0.0", "cap-5.5.0-HF01"));
        TestInstallOfDeprecatedPkg.assertFalse((boolean)this.pm.matchesPlatform("nuxeo-flavors-unicolor-1.0.0", "cap-5.5.0-something"));
        TestInstallOfDeprecatedPkg.assertFalse((boolean)this.pm.matchesPlatform("nuxeo-flavors-unicolor-1.0.0", "cap-5.6.0"));
    }
}

