/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.pm.tests;

import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.nuxeo.connect.data.DownloadablePackage;
import org.nuxeo.connect.packages.PackageSource;
import org.nuxeo.connect.pm.tests.AbstractPackageManagerTestCase;
import org.nuxeo.connect.pm.tests.DummyPackageSource;
import org.nuxeo.connect.update.PackageState;

public class TestPackageManager
extends AbstractPackageManagerTestCase {
    public void testPM() throws Exception {
        List<DownloadablePackage> local = TestPackageManager.getDownloads("local1.json");
        List<DownloadablePackage> remote = TestPackageManager.getDownloads("remote1.json");
        TestPackageManager.assertTrue((boolean)CollectionUtils.isNotEmpty(local));
        TestPackageManager.assertTrue((boolean)CollectionUtils.isNotEmpty(remote));
        this.pm.registerSource((PackageSource)new DummyPackageSource(local, "local1"), true);
        this.pm.registerSource((PackageSource)new DummyPackageSource(remote, "remote1"), false);
        List remotes = this.pm.listRemotePackages();
        this.dumpPkgList("remote", remotes);
        TestPackageManager.assertEquals((int)5, (int)remotes.size());
        List locals = this.pm.listLocalPackages();
        this.dumpPkgList("local", locals);
        TestPackageManager.assertEquals((int)2, (int)locals.size());
        List all = this.pm.listPackages();
        this.dumpPkgList("all", all);
        TestPackageManager.assertEquals((int)7, (int)all.size());
        List updates = this.pm.listUpdatePackages();
        this.dumpPkgList("update", updates);
        TestPackageManager.assertEquals((int)1, (int)updates.size());
        List remoteOnly = this.pm.listOnlyRemotePackages(null, null);
        this.dumpPkgList("remoteOnly", remoteOnly);
        TestPackageManager.assertEquals((int)4, (int)remoteOnly.size());
        List studioOnly = this.pm.listRemoteAssociatedStudioPackages();
        this.dumpPkgList("studioOnly", studioOnly);
        TestPackageManager.assertEquals((int)2, (int)studioOnly.size());
    }

    public void testPMLocalOverride() throws Exception {
        List<DownloadablePackage> local = TestPackageManager.getDownloads("local2.json");
        List<DownloadablePackage> remote = TestPackageManager.getDownloads("remote2.json");
        TestPackageManager.assertTrue((boolean)CollectionUtils.isNotEmpty(local));
        TestPackageManager.assertTrue((boolean)CollectionUtils.isNotEmpty(remote));
        this.pm.registerSource((PackageSource)new DummyPackageSource(local, "local2"), true);
        this.pm.registerSource((PackageSource)new DummyPackageSource(remote, "remote2"), false);
        List remotes = this.pm.listRemotePackages();
        this.dumpPkgList("remote", remotes);
        TestPackageManager.assertEquals((int)3, (int)remotes.size());
        List locals = this.pm.listLocalPackages();
        this.dumpPkgList("local", locals);
        TestPackageManager.assertEquals((int)3, (int)locals.size());
        List all = this.pm.listPackages();
        this.dumpPkgList("all", all);
        TestPackageManager.assertEquals((int)4, (int)all.size());
        DownloadablePackage downloading = (DownloadablePackage)all.get(1);
        TestPackageManager.assertEquals((Object)PackageState.DOWNLOADING, (Object)downloading.getPackageState());
        List updates = this.pm.listUpdatePackages();
        this.dumpPkgList("update", updates);
        TestPackageManager.assertEquals((int)0, (int)updates.size());
        List remoteOnly = this.pm.listOnlyRemotePackages(null, null);
        this.dumpPkgList("remoteOnly", remoteOnly);
        TestPackageManager.assertEquals((int)1, (int)remoteOnly.size());
        List remoteOrLocal = this.pm.listRemoteOrLocalPackages(null, null);
        this.dumpPkgList("remoteOrLocal", remoteOrLocal);
        TestPackageManager.assertEquals((int)3, (int)remoteOrLocal.size());
        downloading = (DownloadablePackage)remoteOrLocal.get(1);
        TestPackageManager.assertEquals((Object)PackageState.INSTALLED, (Object)downloading.getPackageState());
    }

    public void testUpdateListing() throws Exception {
        List<DownloadablePackage> local = TestPackageManager.getDownloads("localhf1.json");
        List<DownloadablePackage> remote = TestPackageManager.getDownloads("remotehf1.json");
        TestPackageManager.assertTrue((boolean)CollectionUtils.isNotEmpty(local));
        TestPackageManager.assertTrue((boolean)CollectionUtils.isNotEmpty(remote));
        this.pm.registerSource((PackageSource)new DummyPackageSource(local, "localhf1"), true);
        this.pm.registerSource((PackageSource)new DummyPackageSource(remote, "remotehf1"), false);
        List remotes = this.pm.listRemotePackages();
        this.dumpPkgList("remote", remotes);
        TestPackageManager.assertEquals((int)4, (int)remotes.size());
        List locals = this.pm.listLocalPackages();
        this.dumpPkgList("local", locals);
        TestPackageManager.assertEquals((int)3, (int)locals.size());
        List updates = this.pm.listUpdatePackages();
        this.dumpPkgList("updates", updates);
        TestPackageManager.assertEquals((int)3, (int)updates.size());
        for (DownloadablePackage update : updates) {
            TestPackageManager.assertFalse((update.getPackageState() == PackageState.INSTALLING || update.getPackageState() == PackageState.INSTALLED || update.getPackageState() == PackageState.STARTED ? 1 : 0) != 0);
        }
    }
}

