/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.pm.tests;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.nuxeo.connect.data.DownloadablePackage;
import org.nuxeo.connect.packages.PackageSource;
import org.nuxeo.connect.packages.dependencies.DependencyResolution;
import org.nuxeo.connect.pm.tests.AbstractPackageManagerTestCase;
import org.nuxeo.connect.pm.tests.DummyPackageSource;
import org.nuxeo.connect.update.Version;

public class TestRemoveP2CUDF
extends AbstractPackageManagerTestCase {
    @Override
    public void setUp() throws Exception {
        super.setUp();
        List<DownloadablePackage> local = TestRemoveP2CUDF.getDownloads("local4.json");
        TestRemoveP2CUDF.assertTrue((boolean)CollectionUtils.isNotEmpty(local));
        this.pm.registerSource((PackageSource)new DummyPackageSource(local, "local4"), true);
    }

    public void testResolutionOrder() throws Exception {
        ArrayList<String> uninstalls = new ArrayList<String>();
        uninstalls.add("nuxeo-content-browser:1.0.0");
        DependencyResolution depResolution = this.pm.resolveDependencies(null, uninstalls, null, null, true);
        log.info((Object)depResolution.toString());
        TestRemoveP2CUDF.assertTrue((boolean)depResolution.isValidated());
        TestRemoveP2CUDF.assertEquals((int)3, (int)depResolution.getRemovePackageIds().size());
        TestRemoveP2CUDF.assertEquals((String)"[nuxeo-social-collaboration-5.6.0-SNAPSHOT, nuxeo-dm-5.6.0-SNAPSHOT, nuxeo-content-browser-1.1.0]", (String)depResolution.getOrderedPackageIdsToRemove().toString());
        TestRemoveP2CUDF.assertEquals((Object)new Version("1.1.0"), depResolution.getLocalPackagesToRemove().get("nuxeo-content-browser"));
        depResolution = this.pm.resolveDependencies(null, uninstalls, null, null, false);
        log.info((Object)depResolution.toString());
        TestRemoveP2CUDF.assertTrue((boolean)depResolution.isValidated());
        TestRemoveP2CUDF.assertEquals((int)3, (int)depResolution.getRemovePackageIds().size());
        TestRemoveP2CUDF.assertEquals((String)"[nuxeo-social-collaboration-5.6.0-SNAPSHOT, nuxeo-dm-5.6.0-SNAPSHOT, nuxeo-content-browser-1.1.0]", (String)depResolution.getOrderedPackageIdsToRemove().toString());
        TestRemoveP2CUDF.assertEquals((Object)new Version("1.1.0"), depResolution.getLocalPackagesToRemove().get("nuxeo-content-browser"));
    }
}

