/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.pm.tests;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.nuxeo.connect.data.DownloadablePackage;
import org.nuxeo.connect.packages.PackageSource;
import org.nuxeo.connect.packages.dependencies.DependencyResolution;
import org.nuxeo.connect.pm.tests.AbstractPackageManagerTestCase;
import org.nuxeo.connect.pm.tests.DummyPackageSource;
import org.nuxeo.connect.update.Version;

public class TestSNAPSHOT
extends AbstractPackageManagerTestCase {
    @Override
    public void setUp() throws Exception {
        super.setUp();
        List<DownloadablePackage> local = TestSNAPSHOT.getDownloads("localsnapshot.json");
        List<DownloadablePackage> remote = TestSNAPSHOT.getDownloads("remotesnapshot.json");
        TestSNAPSHOT.assertTrue((boolean)CollectionUtils.isNotEmpty(local));
        TestSNAPSHOT.assertTrue((boolean)CollectionUtils.isNotEmpty(remote));
        this.pm.registerSource((PackageSource)new DummyPackageSource(local, "localsnapshot"), true);
        this.pm.registerSource((PackageSource)new DummyPackageSource(remote, "remotesnapshot"), false);
    }

    public void testAWithoutSNAPSHOT() throws Exception {
        DependencyResolution depResolution = this.pm.resolveDependencies(Arrays.asList("A"), null, null, null);
        log.info((Object)depResolution.toString());
        TestSNAPSHOT.assertTrue((boolean)depResolution.isValidated());
        TestSNAPSHOT.assertFalse((boolean)depResolution.requireChanges());
        ArrayList<String> installs = new ArrayList<String>();
        installs.add("A-1.0.1-SNAPSHOT");
        depResolution = this.pm.resolveDependencies(installs, null, null, null, true);
        log.info((Object)depResolution.toString());
        TestSNAPSHOT.assertTrue((boolean)depResolution.isValidated());
        TestSNAPSHOT.assertEquals((int)1, (int)depResolution.getLocalPackagesToInstall().size());
        TestSNAPSHOT.assertEquals((Object)new Version("1.0.1-SNAPSHOT"), depResolution.getLocalPackagesToInstall().get("A"));
        TestSNAPSHOT.assertEquals((int)1, (int)depResolution.getLocalPackagesToUpgrade().size());
        TestSNAPSHOT.assertEquals((int)2, (int)depResolution.getLocalUnchangedPackages().size());
        TestSNAPSHOT.assertEquals((int)0, (int)depResolution.getNewPackagesToDownload().size());
        TestSNAPSHOT.assertEquals((int)0, (int)depResolution.getLocalPackagesToRemove().size());
    }

    public void testBWithoutSNAPSHOT() throws Exception {
        DependencyResolution depResolution = this.pm.resolveDependencies(Arrays.asList("B-1.0.2-SNAPSHOT"), null, null, null);
        log.info((Object)depResolution.toString());
        TestSNAPSHOT.assertTrue((boolean)depResolution.isValidated());
        TestSNAPSHOT.assertEquals((int)1, (int)depResolution.getLocalPackagesToInstall().size());
        TestSNAPSHOT.assertEquals((Object)new Version("1.0.2-SNAPSHOT"), depResolution.getLocalPackagesToInstall().get("B"));
        TestSNAPSHOT.assertEquals((int)1, (int)depResolution.getLocalPackagesToUpgrade().size());
        TestSNAPSHOT.assertEquals((Object)new Version("1.0.1-SNAPSHOT"), depResolution.getLocalPackagesToUpgrade().get("B"));
        TestSNAPSHOT.assertEquals((int)2, (int)depResolution.getLocalUnchangedPackages().size());
        TestSNAPSHOT.assertEquals((int)0, (int)depResolution.getLocalPackagesToRemove().size());
        TestSNAPSHOT.assertEquals((int)0, (int)depResolution.getNewPackagesToDownload().size());
        ArrayList<String> installs = new ArrayList<String>();
        installs.add("B-1.0.1");
        depResolution = this.pm.resolveDependencies(installs, null, null, null);
        log.info((Object)depResolution.toString());
        TestSNAPSHOT.assertTrue((boolean)depResolution.isValidated());
        TestSNAPSHOT.assertEquals((int)0, (int)depResolution.getLocalPackagesToInstall().size());
        TestSNAPSHOT.assertEquals((int)1, (int)depResolution.getLocalPackagesToUpgrade().size());
        TestSNAPSHOT.assertEquals((int)2, (int)depResolution.getLocalUnchangedPackages().size());
        TestSNAPSHOT.assertEquals((int)1, (int)depResolution.getNewPackagesToDownload().size());
        TestSNAPSHOT.assertEquals((Object)new Version("1.0.1"), depResolution.getNewPackagesToDownload().get("B"));
        TestSNAPSHOT.assertEquals((int)0, (int)depResolution.getLocalPackagesToRemove().size());
    }

    public void testB2WithoutSNAPSHOT() throws Exception {
        DependencyResolution depResolution = this.pm.resolveDependencies(Arrays.asList("B2-1.0.2-SNAPSHOT"), null, null, null);
        log.info((Object)depResolution.toString());
        TestSNAPSHOT.assertTrue((boolean)depResolution.isValidated());
        TestSNAPSHOT.assertEquals((int)1, (int)depResolution.getLocalPackagesToInstall().size());
        TestSNAPSHOT.assertEquals((int)1, (int)depResolution.getLocalPackagesToUpgrade().size());
        TestSNAPSHOT.assertEquals((int)2, (int)depResolution.getLocalUnchangedPackages().size());
        TestSNAPSHOT.assertEquals((int)0, (int)depResolution.getLocalPackagesToRemove().size());
        TestSNAPSHOT.assertEquals((int)0, (int)depResolution.getNewPackagesToDownload().size());
        ArrayList<String> uninstalls = new ArrayList<String>();
        uninstalls.add("B2");
        depResolution = this.pm.resolveDependencies(null, uninstalls, null, null);
        log.info((Object)depResolution.toString());
        TestSNAPSHOT.assertTrue((boolean)depResolution.isValidated());
        TestSNAPSHOT.assertEquals((int)0, (int)depResolution.getLocalPackagesToInstall().size());
        TestSNAPSHOT.assertEquals((int)0, (int)depResolution.getLocalPackagesToUpgrade().size());
        TestSNAPSHOT.assertEquals((int)2, (int)depResolution.getLocalUnchangedPackages().size());
        TestSNAPSHOT.assertEquals((int)1, (int)depResolution.getLocalPackagesToRemove().size());
        TestSNAPSHOT.assertEquals((int)0, (int)depResolution.getNewPackagesToDownload().size());
        uninstalls = new ArrayList();
        uninstalls.add("B");
        uninstalls.add("B2-1.0.1-SNAPSHOT");
        depResolution = this.pm.resolveDependencies(null, uninstalls, null, null);
        log.info((Object)depResolution.toString());
        TestSNAPSHOT.assertTrue((boolean)depResolution.isValidated());
        TestSNAPSHOT.assertEquals((int)0, (int)depResolution.getLocalPackagesToInstall().size());
        TestSNAPSHOT.assertEquals((int)0, (int)depResolution.getLocalPackagesToUpgrade().size());
        TestSNAPSHOT.assertEquals((int)1, (int)depResolution.getLocalUnchangedPackages().size());
        TestSNAPSHOT.assertEquals((int)2, (int)depResolution.getLocalPackagesToRemove().size());
        TestSNAPSHOT.assertEquals((int)0, (int)depResolution.getNewPackagesToDownload().size());
    }

    public void testCWithoutSNAPSHOT() throws Exception {
        DependencyResolution depResolution = this.pm.resolveDependencies(Arrays.asList("C"), null, null, null);
        log.info((Object)depResolution.toString());
        TestSNAPSHOT.assertTrue((boolean)depResolution.isValidated());
        TestSNAPSHOT.assertEquals((int)0, (int)depResolution.getLocalPackagesToInstall().size());
        TestSNAPSHOT.assertEquals((int)0, (int)depResolution.getLocalPackagesToUpgrade().size());
        TestSNAPSHOT.assertEquals((int)3, (int)depResolution.getLocalUnchangedPackages().size());
        TestSNAPSHOT.assertEquals((int)1, (int)depResolution.getNewPackagesToDownload().size());
        TestSNAPSHOT.assertEquals((Object)new Version("1.0.1"), depResolution.getNewPackagesToDownload().get("C"));
        TestSNAPSHOT.assertEquals((int)0, (int)depResolution.getLocalPackagesToRemove().size());
        depResolution = this.pm.resolveDependencies(Arrays.asList("C-1.0.1"), null, null, null);
        log.info((Object)depResolution.toString());
        TestSNAPSHOT.assertTrue((boolean)depResolution.isValidated());
        TestSNAPSHOT.assertEquals((int)0, (int)depResolution.getLocalPackagesToInstall().size());
        TestSNAPSHOT.assertEquals((int)0, (int)depResolution.getLocalPackagesToUpgrade().size());
        TestSNAPSHOT.assertEquals((int)3, (int)depResolution.getLocalUnchangedPackages().size());
        TestSNAPSHOT.assertEquals((int)1, (int)depResolution.getNewPackagesToDownload().size());
        TestSNAPSHOT.assertEquals((Object)new Version("1.0.1"), depResolution.getNewPackagesToDownload().get("C"));
        TestSNAPSHOT.assertEquals((int)0, (int)depResolution.getLocalPackagesToRemove().size());
        depResolution = this.pm.resolveDependencies(Arrays.asList("C-1.0.1-SNAPSHOT"), null, null, null);
        log.info((Object)depResolution.toString());
        TestSNAPSHOT.assertTrue((boolean)depResolution.isValidated());
        TestSNAPSHOT.assertEquals((int)1, (int)depResolution.getLocalPackagesToInstall().size());
        TestSNAPSHOT.assertEquals((Object)new Version("1.0.1-SNAPSHOT"), depResolution.getLocalPackagesToInstall().get("C"));
        TestSNAPSHOT.assertEquals((int)0, (int)depResolution.getLocalPackagesToUpgrade().size());
        TestSNAPSHOT.assertEquals((int)3, (int)depResolution.getLocalUnchangedPackages().size());
        TestSNAPSHOT.assertEquals((int)0, (int)depResolution.getNewPackagesToDownload().size());
        TestSNAPSHOT.assertEquals((int)0, (int)depResolution.getLocalPackagesToRemove().size());
    }

    public void testAWithSNAPSHOT() throws Exception {
        ArrayList<String> installs = new ArrayList<String>();
        installs.add("A");
        DependencyResolution depResolution = this.pm.resolveDependencies(installs, null, null, null, true);
        log.info((Object)depResolution.toString());
        TestSNAPSHOT.assertTrue((boolean)depResolution.isValidated());
        TestSNAPSHOT.assertFalse((boolean)depResolution.requireChanges());
        TestSNAPSHOT.assertEquals((int)0, (int)depResolution.getLocalPackagesToInstall().size());
        TestSNAPSHOT.assertEquals((int)0, (int)depResolution.getLocalPackagesToUpgrade().size());
        TestSNAPSHOT.assertEquals((int)3, (int)depResolution.getLocalUnchangedPackages().size());
        TestSNAPSHOT.assertEquals((int)0, (int)depResolution.getNewPackagesToDownload().size());
        TestSNAPSHOT.assertEquals((int)0, (int)depResolution.getLocalPackagesToRemove().size());
        installs = new ArrayList();
        installs.add("A-1.0.2-SNAPSHOT");
        depResolution = this.pm.resolveDependencies(installs, null, null, null, true);
        log.info((Object)depResolution.toString());
        TestSNAPSHOT.assertTrue((boolean)depResolution.isValidated());
        TestSNAPSHOT.assertEquals((int)0, (int)depResolution.getLocalPackagesToInstall().size());
        TestSNAPSHOT.assertEquals((int)1, (int)depResolution.getLocalPackagesToUpgrade().size());
        TestSNAPSHOT.assertEquals((int)2, (int)depResolution.getLocalUnchangedPackages().size());
        TestSNAPSHOT.assertEquals((int)1, (int)depResolution.getNewPackagesToDownload().size());
        TestSNAPSHOT.assertEquals((Object)new Version("1.0.2-SNAPSHOT"), depResolution.getNewPackagesToDownload().get("A"));
        TestSNAPSHOT.assertEquals((int)0, (int)depResolution.getLocalPackagesToRemove().size());
    }

    public void testBWithSNAPSHOT() throws Exception {
        ArrayList<String> installs = new ArrayList<String>();
        installs.add("B");
        DependencyResolution depResolution = this.pm.resolveDependencies(installs, null, null, null, true);
        log.info((Object)depResolution.toString());
        TestSNAPSHOT.assertTrue((boolean)depResolution.isValidated());
        TestSNAPSHOT.assertFalse((boolean)depResolution.requireChanges());
        TestSNAPSHOT.assertEquals((int)0, (int)depResolution.getLocalPackagesToInstall().size());
        TestSNAPSHOT.assertEquals((int)0, (int)depResolution.getLocalPackagesToUpgrade().size());
        TestSNAPSHOT.assertEquals((int)3, (int)depResolution.getLocalUnchangedPackages().size());
        TestSNAPSHOT.assertEquals((int)0, (int)depResolution.getNewPackagesToDownload().size());
        TestSNAPSHOT.assertEquals((int)0, (int)depResolution.getLocalPackagesToRemove().size());
        installs = new ArrayList();
        installs.add("B-1.0.2-SNAPSHOT");
        depResolution = this.pm.resolveDependencies(installs, null, null, null, true);
        log.info((Object)depResolution.toString());
        TestSNAPSHOT.assertTrue((boolean)depResolution.isValidated());
        TestSNAPSHOT.assertEquals((int)1, (int)depResolution.getLocalPackagesToInstall().size());
        TestSNAPSHOT.assertEquals((Object)new Version("1.0.2-SNAPSHOT"), depResolution.getLocalPackagesToInstall().get("B"));
        TestSNAPSHOT.assertEquals((int)1, (int)depResolution.getLocalPackagesToUpgrade().size());
        TestSNAPSHOT.assertEquals((int)2, (int)depResolution.getLocalUnchangedPackages().size());
        TestSNAPSHOT.assertEquals((int)0, (int)depResolution.getNewPackagesToDownload().size());
        TestSNAPSHOT.assertEquals((int)0, (int)depResolution.getLocalPackagesToRemove().size());
        installs = new ArrayList();
        installs.add("B-1.0.1");
        depResolution = this.pm.resolveDependencies(installs, null, null, null, true);
        log.info((Object)depResolution.toString());
        TestSNAPSHOT.assertTrue((boolean)depResolution.isValidated());
        TestSNAPSHOT.assertEquals((int)0, (int)depResolution.getLocalPackagesToInstall().size());
        TestSNAPSHOT.assertEquals((int)1, (int)depResolution.getLocalPackagesToUpgrade().size());
        TestSNAPSHOT.assertEquals((int)2, (int)depResolution.getLocalUnchangedPackages().size());
        TestSNAPSHOT.assertEquals((int)1, (int)depResolution.getNewPackagesToDownload().size());
        TestSNAPSHOT.assertEquals((Object)new Version("1.0.1"), depResolution.getNewPackagesToDownload().get("B"));
        TestSNAPSHOT.assertEquals((int)0, (int)depResolution.getLocalPackagesToRemove().size());
    }

    public void testCWithSNAPSHOT() throws Exception {
        ArrayList<String> installs = new ArrayList<String>();
        installs.add("C");
        DependencyResolution depResolution = this.pm.resolveDependencies(installs, null, null, null, true);
        log.info((Object)depResolution.toString());
        TestSNAPSHOT.assertTrue((boolean)depResolution.isValidated());
        TestSNAPSHOT.assertEquals((int)1, (int)depResolution.getLocalPackagesToInstall().size());
        TestSNAPSHOT.assertEquals((int)0, (int)depResolution.getLocalPackagesToUpgrade().size());
        TestSNAPSHOT.assertEquals((int)3, (int)depResolution.getLocalUnchangedPackages().size());
        TestSNAPSHOT.assertEquals((int)0, (int)depResolution.getNewPackagesToDownload().size());
        TestSNAPSHOT.assertEquals((int)0, (int)depResolution.getLocalPackagesToRemove().size());
        installs = new ArrayList();
        installs.add("C-1.0.1");
        depResolution = this.pm.resolveDependencies(installs, null, null, null, true);
        log.info((Object)depResolution.toString());
        TestSNAPSHOT.assertTrue((boolean)depResolution.isValidated());
        TestSNAPSHOT.assertEquals((int)0, (int)depResolution.getLocalPackagesToInstall().size());
        TestSNAPSHOT.assertEquals((int)0, (int)depResolution.getLocalPackagesToUpgrade().size());
        TestSNAPSHOT.assertEquals((int)3, (int)depResolution.getLocalUnchangedPackages().size());
        TestSNAPSHOT.assertEquals((int)1, (int)depResolution.getNewPackagesToDownload().size());
        TestSNAPSHOT.assertEquals((Object)new Version("1.0.1"), depResolution.getNewPackagesToDownload().get("C"));
        TestSNAPSHOT.assertEquals((int)0, (int)depResolution.getLocalPackagesToRemove().size());
    }
}

