/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.pm.tests;

import java.util.ArrayList;
import java.util.Collections;
import junit.framework.TestCase;
import org.nuxeo.connect.update.Version;

public class TestVersions
extends TestCase {
    public void testVersions() {
        TestVersions.assertEquals((int)-1, (int)new Version("5.2.1-RC1").compareTo(new Version("5.2.1")));
        ArrayList<Version> versions = new ArrayList<Version>();
        versions.add(new Version("5"));
        versions.add(new Version("5.0"));
        versions.add(new Version("5.0.0"));
        versions.add(new Version("5.0.1"));
        versions.add(new Version("5.2.1"));
        versions.add(new Version("5.2.1-SNAPSHOT"));
        versions.add(new Version("5.2.1-RC1"));
        versions.add(new Version("5.2.1-RC2"));
        versions.add(new Version("5.0.1-SNAPSHOT"));
        versions.add(new Version("5.0.1-CMF"));
        versions.add(new Version("5.0.1-CMF-SNAPSHOT"));
        versions.add(new Version("5.0.1-beta"));
        versions.add(new Version("5.0.1-BETA"));
        versions.add(new Version("5.0.1-something"));
        versions.add(new Version("5.0.1-anything"));
        versions.add(new Version("5.0.1-I20130101"));
        versions.add(new Version("5.0.1-I20121225"));
        Collections.shuffle(versions);
        Collections.sort(versions);
        ArrayList<Version> expectedOrder = new ArrayList<Version>();
        expectedOrder.add(new Version("5"));
        expectedOrder.add(new Version("5"));
        expectedOrder.add(new Version("5"));
        expectedOrder.add(new Version("5.0.1-BETA"));
        expectedOrder.add(new Version("5.0.1-I20121225"));
        expectedOrder.add(new Version("5.0.1-I20130101"));
        expectedOrder.add(new Version("5.0.1-beta"));
        expectedOrder.add(new Version("5.0.1-SNAPSHOT"));
        expectedOrder.add(new Version("5.0.1"));
        expectedOrder.add(new Version("5.0.1-CMF-SNAPSHOT"));
        expectedOrder.add(new Version("5.0.1-CMF"));
        expectedOrder.add(new Version("5.0.1-anything"));
        expectedOrder.add(new Version("5.0.1-something"));
        expectedOrder.add(new Version("5.2.1-RC1"));
        expectedOrder.add(new Version("5.2.1-RC2"));
        expectedOrder.add(new Version("5.2.1-SNAPSHOT"));
        expectedOrder.add(new Version("5.2.1"));
        TestVersions.assertEquals(expectedOrder, versions);
    }

    public void testParsingVersions() {
        Version versionRef = new Version(7, 3, 12, "BETA");
        versionRef.setSnapshot(true);
        Version version1 = new Version("7.3.12-BETA-SNAPSHOT");
        TestVersions.assertEquals((Object)versionRef, (Object)version1);
        TestVersions.assertEquals((int)7, (int)version1.major());
        TestVersions.assertEquals((int)3, (int)version1.minor());
        TestVersions.assertEquals((int)12, (int)version1.patch());
        TestVersions.assertEquals((String)"BETA", (String)version1.classifier());
        TestVersions.assertTrue((boolean)version1.isSnapshot());
        TestVersions.assertTrue((boolean)version1.isSpecialClassifier());
        Version version2 = new Version("7.3.12-SNAPSHOT-BETA");
        TestVersions.assertEquals((Object)versionRef, (Object)version1);
        TestVersions.assertEquals((Object)version1, (Object)version2);
        TestVersions.assertEquals((String)"BETA", (String)version2.classifier());
        TestVersions.assertTrue((boolean)version2.isSnapshot());
        TestVersions.assertTrue((boolean)version2.isSpecialClassifier());
    }
}

