/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.tests;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.junit.Test;
import org.nuxeo.connect.identity.LogicalInstanceIdentifier;
import org.nuxeo.connect.identity.TechnicalInstanceIdentifier;

public class TestIDGens {
    private static final String TOTO_TITI = "toto--titi";
    private static final Log log = LogFactory.getLog(TestIDGens.class);

    @Test
    public void testCTIDGen() {
        TechnicalInstanceIdentifier ctid = new TechnicalInstanceIdentifier();
        String ctId1 = ctid.getCTID();
        TechnicalInstanceIdentifier ctid2 = new TechnicalInstanceIdentifier();
        String ctId2 = ctid2.getCTID();
        log.info((Object)ctId1);
        Assert.assertEquals((Object)ctId1, (Object)ctId2);
    }

    protected void dotestCLID(LogicalInstanceIdentifier CLID) throws IOException, LogicalInstanceIdentifier.InvalidCLID {
        CLID.save();
        LogicalInstanceIdentifier CLID2 = LogicalInstanceIdentifier.load();
        Assert.assertNotNull((Object)CLID2);
        Assert.assertEquals((Object)CLID.getCLID1(), (Object)CLID2.getCLID1());
        Assert.assertEquals((Object)CLID.getCLID2(), (Object)CLID2.getCLID2());
        Assert.assertEquals((Object)CLID.getInstanceDescription(), (Object)CLID2.getInstanceDescription());
    }

    @Test
    public void testCLIDPlainText() throws LogicalInstanceIdentifier.InvalidCLID, IOException {
        LogicalInstanceIdentifier.USE_BASE64_SAVE = false;
        LogicalInstanceIdentifier CLID = new LogicalInstanceIdentifier(TOTO_TITI, "myInstance");
        this.dotestCLID(CLID);
    }

    @Test
    public void testCLIDEncoded() throws LogicalInstanceIdentifier.InvalidCLID, IOException {
        LogicalInstanceIdentifier.USE_BASE64_SAVE = true;
        LogicalInstanceIdentifier CLID = new LogicalInstanceIdentifier(TOTO_TITI, "myInstance");
        this.dotestCLID(CLID);
    }

    @Test
    public void testCanReloadEmptyDescriptionCLID() throws LogicalInstanceIdentifier.InvalidCLID, IOException {
        LogicalInstanceIdentifier CLID = new LogicalInstanceIdentifier(TOTO_TITI);
        this.dotestCLID(CLID);
    }

    @Test(expected=LogicalInstanceIdentifier.InvalidCLID.class)
    public void testInvalidCLID() throws IOException, LogicalInstanceIdentifier.InvalidCLID {
        Path tempCLID = Files.createTempFile("instance", ".clid", new FileAttribute[0]);
        Files.write(tempCLID, "invalid CLID with only one line".getBytes(), new OpenOption[0]);
        try {
            LogicalInstanceIdentifier.load((String)tempCLID.toString());
        }
        finally {
            Files.delete(tempCLID);
        }
    }
}

