/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.update;

import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;
import org.nuxeo.connect.update.PackageUtils;

public class PackageUtilsTest {
    @Test
    public void testPackageNames() {
        ArrayList<String> packageIds1 = new ArrayList<String>();
        packageIds1.add("jcarsique-SANDBOX-0.0.2");
        packageIds1.add("jcarsique-SANDBOX-5.0.1-BETA");
        packageIds1.add("jcarsique-SANDBOX-5.0.1-I20121225");
        packageIds1.add("jcarsique-SANDBOX-5.0.1-I20130101");
        packageIds1.add("jcarsique-SANDBOX-5.0.1-beta");
        packageIds1.add("jcarsique-SANDBOX-5.0.1-SNAPSHOT");
        packageIds1.add("jcarsique-SANDBOX-5.0.1");
        packageIds1.add("jcarsique-SANDBOX-5.0.1-CMF-SNAPSHOT");
        packageIds1.add("jcarsique-SANDBOX-5.0.1-CMF");
        packageIds1.add("jcarsique-SANDBOX-5.0.1-anything");
        packageIds1.add("jcarsique-SANDBOX-5.0.1-something");
        ArrayList<String> packageIds2 = new ArrayList<String>();
        packageIds2.add("FooBar-0.0.0-SNAPSHOT");
        packageIds2.add("FooBar-0.0.2-afterRename");
        packageIds2.add("FooBar-0.0.3-afterResetAll");
        for (String packageId : packageIds1) {
            Assert.assertEquals((Object)"jcarsique-SANDBOX", (Object)PackageUtils.getPackageName((String)packageId));
        }
        for (String packageId : packageIds2) {
            Assert.assertEquals((Object)"FooBar", (Object)PackageUtils.getPackageName((String)packageId));
        }
        Assert.assertFalse((boolean)PackageUtils.isValidPackageId((String)"somePackageName"));
        Assert.assertTrue((boolean)PackageUtils.isValidPackageId((String)"somePackageName-1.0.0"));
        Assert.assertEquals((Object)"somePackageName", (Object)PackageUtils.getPackageName((String)"somePackageName-3.2.10"));
        Assert.assertEquals((Object)"3.2.10", (Object)PackageUtils.getPackageVersion((String)"somePackageName-3.2.10"));
        String packageId = "name.with.dot-and-dash-0.0.1";
        Assert.assertEquals((Object)"name.with.dot-and-dash", (Object)PackageUtils.getPackageName((String)packageId));
        Assert.assertEquals((Object)"0.0.1", (Object)PackageUtils.getPackageVersion((String)packageId));
    }
}

