/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.update;

import org.junit.Assert;
import org.junit.Test;
import org.nuxeo.connect.update.Version;
import org.nuxeo.connect.update.VersionRange;

public class VersionRangeTest {
    @Test
    public void testMatchVersion() {
        Version v4 = new Version("4");
        Version v5 = new Version("5");
        Version v7 = new Version("7");
        Version v10 = new Version("10");
        Version v12 = new Version("12");
        VersionRange vr5To10 = new VersionRange(v5, v10);
        VersionRange vr5Min = new VersionRange(v5);
        VersionRange vr10Max = new VersionRange(null, v10);
        Assert.assertFalse((String)(vr5To10 + " must not match " + v4), (boolean)vr5To10.matchVersion(v4));
        Assert.assertTrue((String)(vr5To10 + " must match " + v5), (boolean)vr5To10.matchVersion(v5));
        Assert.assertTrue((String)(vr5To10 + " must match " + v7), (boolean)vr5To10.matchVersion(v7));
        Assert.assertTrue((String)(vr5To10 + " must match " + v10), (boolean)vr5To10.matchVersion(v10));
        Assert.assertFalse((String)(vr5To10 + " must not match " + v12), (boolean)vr5To10.matchVersion(v12));
        Assert.assertFalse((String)(vr5Min + " must not match " + v4), (boolean)vr5Min.matchVersion(v4));
        Assert.assertTrue((String)(vr5Min + " must match " + v5), (boolean)vr5Min.matchVersion(v5));
        Assert.assertTrue((String)(vr5Min + " must match " + v7), (boolean)vr5Min.matchVersion(v7));
        Assert.assertTrue((String)(vr5Min + " must match " + v10), (boolean)vr5Min.matchVersion(v10));
        Assert.assertTrue((String)(vr5Min + " must not match " + v12), (boolean)vr5Min.matchVersion(v12));
        Assert.assertTrue((String)(vr10Max + " must not match " + v4), (boolean)vr10Max.matchVersion(v4));
        Assert.assertTrue((String)(vr10Max + " must match " + v5), (boolean)vr10Max.matchVersion(v5));
        Assert.assertTrue((String)(vr10Max + " must match " + v7), (boolean)vr10Max.matchVersion(v7));
        Assert.assertTrue((String)(vr10Max + " must match " + v10), (boolean)vr10Max.matchVersion(v10));
        Assert.assertFalse((String)(vr10Max + " must not match " + v12), (boolean)vr10Max.matchVersion(v12));
        VersionRange vr = new VersionRange("5.7-I20121210_0116:5.7");
        Assert.assertTrue((boolean)vr.matchVersion(new Version("5.7-I20121210_0116")));
        Assert.assertTrue((boolean)vr.matchVersion(new Version("5.7-SNAPSHOT")));
        Assert.assertTrue((boolean)vr.matchVersion(new Version("5.7-I20130101_0101")));
        Assert.assertFalse((boolean)vr.matchVersion(new Version("5.6-I20130101_0101")));
        Assert.assertFalse((boolean)vr.matchVersion(new Version("5.6")));
        Assert.assertFalse((boolean)vr.matchVersion(new Version("5.6-SNAPSHOT")));
        Assert.assertFalse((boolean)vr.matchVersion(new Version("5.8")));
    }

    @Test
    public void testMatchVersionRange() {
        VersionRange vr5To10 = new VersionRange("5:10");
        VersionRange vr15To20 = new VersionRange("15:20");
        VersionRange vr7To25 = new VersionRange("7:25");
        VersionRange vr12Min = new VersionRange("12");
        VersionRange vr12Max = new VersionRange(null, new Version("12"));
        Assert.assertTrue((String)(vr5To10 + " must match " + vr5To10), (boolean)vr5To10.matchVersionRange(vr5To10));
        Assert.assertFalse((String)(vr5To10 + " must not match " + vr15To20), (boolean)vr5To10.matchVersionRange(vr15To20));
        Assert.assertFalse((String)(vr15To20 + " must not match " + vr5To10), (boolean)vr15To20.matchVersionRange(vr5To10));
        Assert.assertTrue((String)(vr5To10 + " must match " + vr7To25), (boolean)vr5To10.matchVersionRange(vr7To25));
        Assert.assertFalse((String)(vr5To10 + " must not match " + vr12Min), (boolean)vr5To10.matchVersionRange(vr12Min));
        Assert.assertTrue((String)(vr5To10 + " must match " + vr12Max), (boolean)vr5To10.matchVersionRange(vr12Max));
        Assert.assertTrue((String)(vr7To25 + " must match " + vr5To10), (boolean)vr7To25.matchVersionRange(vr5To10));
        Assert.assertTrue((String)(vr7To25 + " must match " + vr15To20), (boolean)vr7To25.matchVersionRange(vr15To20));
        Assert.assertTrue((String)(vr7To25 + " must match " + vr7To25), (boolean)vr7To25.matchVersionRange(vr7To25));
        Assert.assertTrue((String)(vr7To25 + " must match " + vr12Min), (boolean)vr7To25.matchVersionRange(vr12Min));
        Assert.assertTrue((String)(vr7To25 + " must match " + vr12Max), (boolean)vr7To25.matchVersionRange(vr12Max));
        Assert.assertTrue((String)(vr12Min + " must match " + vr12Max), (boolean)vr12Min.matchVersionRange(vr12Max));
        Assert.assertTrue((String)(vr12Min + " must match " + vr12Min), (boolean)vr12Min.matchVersionRange(vr12Min));
        Assert.assertTrue((String)(vr12Max + " must match " + vr12Min), (boolean)vr12Max.matchVersionRange(vr12Min));
        Assert.assertTrue((String)(vr12Max + " must match " + vr12Max), (boolean)vr12Max.matchVersionRange(vr12Max));
    }
}

