/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.packages;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.connect.NuxeoConnectClient;
import org.nuxeo.connect.connector.ConnectServerError;
import org.nuxeo.connect.data.DownloadablePackage;
import org.nuxeo.connect.packages.AbstractPackageSource;
import org.nuxeo.connect.packages.PackageListCache;
import org.nuxeo.connect.packages.PackageSource;
import org.nuxeo.connect.platform.PlatformId;
import org.nuxeo.connect.registration.ConnectRegistrationService;
import org.nuxeo.connect.update.PackageType;

public class RemotePackageSource
extends AbstractPackageSource
implements PackageSource {
    protected static final Log log = LogFactory.getLog(RemotePackageSource.class);
    protected PackageListCache cache = new PackageListCache();

    public RemotePackageSource() {
        this.id = "remote";
        this.name = "Connect Server";
    }

    @Override
    public List<DownloadablePackage> listPackages() {
        return this.listPackages(null, null);
    }

    @Override
    public List<DownloadablePackage> listStudioPackages(PlatformId currentTargetPlatform) {
        List<DownloadablePackage> result = new ArrayList<DownloadablePackage>();
        if (!NuxeoConnectClient.getConnectGatewayComponent().isInstanceRegistered()) {
            log.info((Object)"Server is not registered");
            return result;
        }
        String cacheKey = "StudioRegistered" + (currentTargetPlatform != null ? "_" + currentTargetPlatform.asString() : "");
        result = this.cache.getFromCache(cacheKey);
        if (!result.isEmpty()) {
            return result;
        }
        try {
            ConnectRegistrationService crs = NuxeoConnectClient.getConnectRegistrationService();
            result = crs.getConnector().getRegisteredStudio(currentTargetPlatform);
            this.cache.add(result, cacheKey);
        }
        catch (ConnectServerError e) {
            log.debug((Object)e, (Throwable)e);
            log.warn((Object)("Unable to fetch remote packages list: " + e.getMessage()));
        }
        return result;
    }

    @Override
    public List<DownloadablePackage> listPackages(PackageType type, PlatformId currentTargetPlatform) {
        if (type == null) {
            ArrayList<DownloadablePackage> all = new ArrayList<DownloadablePackage>();
            for (PackageType pkgType : PackageType.values()) {
                all.addAll(this.listPackages(pkgType, currentTargetPlatform));
            }
            return all;
        }
        String cacheKey = type.toString() + (currentTargetPlatform != null ? "_" + currentTargetPlatform.asString() : "");
        List<DownloadablePackage> result = this.cache.getFromCache(cacheKey);
        if (!result.isEmpty()) {
            return result;
        }
        try {
            ConnectRegistrationService crs = NuxeoConnectClient.getConnectRegistrationService();
            result = crs.getConnector().getDownloads(type, currentTargetPlatform);
        }
        catch (ConnectServerError e) {
            log.debug((Object)e, (Throwable)e);
            log.warn((Object)("Unable to fetch remote packages list: " + e.getMessage()));
            result = new ArrayList<DownloadablePackage>();
        }
        this.cache.add(result, cacheKey);
        return result;
    }

    @Override
    public void flushCache() {
        this.cache = new PackageListCache();
        ConnectRegistrationService crs = NuxeoConnectClient.getConnectRegistrationService();
        crs.getConnector().flushCache();
    }

    @Override
    public DownloadablePackage getPackageById(String packageId) {
        DownloadablePackage pkg = this.cache.getPackageByID(packageId);
        if (pkg == null) {
            ConnectRegistrationService crs = NuxeoConnectClient.getConnectRegistrationService();
            try {
                pkg = crs.getConnector().getDownload(packageId);
            }
            catch (ConnectServerError e) {
                log.debug((Object)e, (Throwable)e);
                log.warn((Object)("Unable to fetch remote package with ID '" + packageId + "': " + e.getMessage()));
            }
            if (pkg != null) {
                this.cache.add(pkg);
            }
        }
        return pkg;
    }

    @Override
    public Collection<? extends DownloadablePackage> listPackagesByName(String packageName, PlatformId currentTargetPlatform) {
        ArrayList<DownloadablePackage> result = new ArrayList<DownloadablePackage>();
        for (PackageType type : PackageType.values()) {
            for (DownloadablePackage pkg : this.listPackages(type, currentTargetPlatform)) {
                if (!packageName.equals(pkg.getName())) continue;
                result.add(pkg);
            }
        }
        return result;
    }
}

