/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.packages.dependencies;

import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.connect.platform.PlatformId;
import org.nuxeo.connect.platform.PlatformVersionRange;
import org.nuxeo.connect.update.Package;

public class TargetPlatformFilterHelper {
    protected static Log log = LogFactory.getLog(TargetPlatformFilterHelper.class);

    public static boolean isCompatibleWithTargetPlatform(Package pkg, PlatformId targetPlatform) {
        if (targetPlatform == null) {
            return true;
        }
        if (StringUtils.isBlank((CharSequence)pkg.getTargetPlatformRange()) || StringUtils.isBlank((CharSequence)pkg.getTargetPlatformName())) {
            return TargetPlatformFilterHelper.isCompatibleWithTargetPlatform(pkg.getTargetPlatforms(), targetPlatform.asString());
        }
        try {
            PlatformVersionRange pkgAllowedTpRange = PlatformVersionRange.fromRangeSpec(pkg.getTargetPlatformRange());
            return pkgAllowedTpRange.containsVersion(targetPlatform.version()) && pkg.getTargetPlatformName().equalsIgnoreCase(targetPlatform.name());
        }
        catch (IllegalArgumentException e) {
            log.warn((Object)String.format("Could not parse target platform range expression '%s' for package '%s', using former compatibility format.", pkg.getTargetPlatformRange(), pkg.getId()), (Throwable)e);
            return TargetPlatformFilterHelper.isCompatibleWithTargetPlatform(pkg.getTargetPlatforms(), targetPlatform.asString());
        }
    }

    private static boolean isCompatibleWithTargetPlatform(String[] targetPlatforms, String targetPlatform) {
        if (targetPlatforms == null || targetPlatforms.length == 0) {
            return true;
        }
        for (String target : targetPlatforms) {
            if (!FilenameUtils.wildcardMatch((String)targetPlatform, (String)target, (IOCase)IOCase.INSENSITIVE)) continue;
            return true;
        }
        return false;
    }
}

