/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.tools.report.viewer;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.IOException;
import java.lang.management.ThreadInfo;
import java.util.Iterator;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.OpenDataException;
import org.jolokia.converter.Converters;
import org.jolokia.converter.object.StringToOpenTypeConverter;
import org.nuxeo.runtime.management.jvm.ThreadDeadlocksDetector;
import sun.management.MappedMXBeanType;

public class ThreadDumpPrinter {
    final ArrayNode dump;
    final StringToOpenTypeConverter converter = new Converters().getToOpenTypeConverter();

    ThreadDumpPrinter(ArrayNode dump) {
        this.dump = dump;
    }

    public Iterable<ThreadInfo> iterableOf() {
        return new Iterable<ThreadInfo>(){

            @Override
            public Iterator<ThreadInfo> iterator() {
                try {
                    return ThreadDumpPrinter.this.iteratorOf();
                }
                catch (IOException cause) {
                    throw new AssertionError("Cannot parse thread dump", cause);
                }
            }
        };
    }

    public Iterator<ThreadInfo> iteratorOf() throws IOException {
        return new Iterator<ThreadInfo>(){
            Iterator<JsonNode> nodes;
            {
                this.nodes = ThreadDumpPrinter.this.dump.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.nodes.hasNext();
            }

            @Override
            public ThreadInfo next() {
                try {
                    return ThreadInfo.from((CompositeData)ThreadDumpPrinter.this.converter.convertToObject(MappedMXBeanType.toOpenType(ThreadInfo.class), (Object)this.nodes.next().toString()));
                }
                catch (OpenDataException cause) {
                    throw new AssertionError("Cannot parse thread info attributes", cause);
                }
            }
        };
    }

    public StringBuilder print(StringBuilder sb) {
        ThreadDeadlocksDetector.JVM16Printer printer = new ThreadDeadlocksDetector.JVM16Printer();
        for (ThreadInfo ti : this.iterableOf()) {
            printer.print(sb, ti);
        }
        return sb;
    }
}

