/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.tools.report.viewer;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Arrays;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.nuxeo.connect.tools.report.viewer.ThreadDumpPrinter;

public class Viewer {
    public static void main(String[] varargs) throws IOException, ParseException {
        class Arguments {
            Options options = new Options().addOption(Option.builder((String)"i").longOpt("input").hasArg().argName("file").desc("report input file").build()).addOption(Option.builder((String)"o").longOpt("output").hasArg().argName("file").desc("thread dump output file").build());
            final CommandLine commandline = new DefaultParser().parse(this.options, this.val$varargs);
            final /* synthetic */ String[] val$varargs;

            Arguments(String[] stringArray) throws ParseException {
                this.val$varargs = stringArray;
            }

            InputStream input() throws IOException {
                if (!this.commandline.hasOption('i')) {
                    return System.in;
                }
                return Files.newInputStream(Paths.get(this.commandline.getOptionValue('i'), new String[0]), new OpenOption[0]);
            }

            PrintStream output() throws IOException {
                if (!this.commandline.hasOption('o')) {
                    return System.out;
                }
                return new PrintStream(this.commandline.getOptionValue('o'));
            }
        }
        Arguments arguments = new Arguments(varargs);
        JsonFactory jsonFactory = new JsonFactory();
        PrintStream output = arguments.output();
        JsonParser parser = jsonFactory.createParser(arguments.input());
        ObjectMapper mapper = new ObjectMapper();
        while (!parser.isClosed() && parser.nextToken() != JsonToken.NOT_AVAILABLE) {
            String hostid = parser.nextFieldName();
            output.println(hostid);
            parser.nextToken();
            while (parser.nextToken() == JsonToken.FIELD_NAME) {
                if ("mx-thread-dump".equals(parser.getCurrentName())) {
                    parser.nextToken();
                    while (parser.nextToken() == JsonToken.FIELD_NAME) {
                        if ("value".equals(parser.getCurrentName())) {
                            parser.nextToken();
                            Viewer.printThreadDump((ArrayNode)mapper.readTree(parser), output);
                            continue;
                        }
                        parser.nextToken();
                        parser.skipChildren();
                    }
                    continue;
                }
                if ("mx-thread-deadlocked".equals(parser.getCurrentName())) {
                    parser.nextToken();
                    while (parser.nextToken() == JsonToken.FIELD_NAME) {
                        if ("value".equals(parser.getCurrentName())) {
                            if (parser.nextToken() != JsonToken.START_ARRAY) continue;
                            Viewer.printThreadDeadlocked((MappingIterator<Long>)((MappingIterator)mapper.readerFor(Long.class).readValue(parser)), output);
                            continue;
                        }
                        parser.nextToken();
                        parser.skipChildren();
                    }
                    continue;
                }
                if ("mx-thread-monitor-deadlocked".equals(parser.getCurrentName())) {
                    parser.nextToken();
                    while (parser.nextToken() == JsonToken.FIELD_NAME) {
                        if ("value".equals(parser.getCurrentName())) {
                            if (parser.nextToken() != JsonToken.START_ARRAY) continue;
                            Viewer.printThreadMonitorDeadlocked((MappingIterator<Long>)mapper.readerFor(Long.class).readValues(parser), output);
                            continue;
                        }
                        parser.nextToken();
                        parser.skipChildren();
                    }
                    continue;
                }
                parser.nextToken();
                parser.skipChildren();
            }
        }
    }

    public static PrintStream printThreadDump(ArrayNode infos, PrintStream out) throws IOException {
        StringBuilder sb = new StringBuilder();
        new ThreadDumpPrinter(infos).print(sb);
        out.print(sb.toString());
        return out;
    }

    public static PrintStream printThreadDeadlocked(MappingIterator<Long> values, PrintStream out) throws IOException {
        out.print("deadlocked " + Arrays.toString(values.readAll().toArray()));
        return out;
    }

    public static PrintStream printThreadMonitorDeadlocked(MappingIterator<Long> values, PrintStream out) throws IOException {
        out.print("monitor deadlocked " + Arrays.toString(values.readAll().toArray()));
        return out;
    }
}

