/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.csv;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CSVImportId {
    private static final Log log = LogFactory.getLog(CSVImportId.class);

    private CSVImportId() {
    }

    public static String create(String repositoryName, String path, File csvFile) {
        return CSVImportId.create(repositoryName, path, CSVImportId.computeDigest(csvFile));
    }

    public static String create(String repositoryName, String path, String csvBlobDigest) {
        return repositoryName + ':' + path + ":csvImport:" + csvBlobDigest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String computeDigest(File file) {
        String string;
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            string = DigestUtils.md5Hex((InputStream)in);
        }
        catch (IOException e) {
            String string2;
            try {
                log.error((Object)e, (Throwable)e);
                string2 = "";
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)in);
            return string2;
        }
        IOUtils.closeQuietly((InputStream)in);
        return string;
    }
}

