/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.functionaltests.dam;

import com.google.common.base.Function;
import java.util.concurrent.TimeUnit;
import org.nuxeo.functionaltests.AbstractTest;
import org.nuxeo.functionaltests.fragment.WebFragmentImpl;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.FluentWait;

public class FoldableBoxFragment
extends WebFragmentImpl {
    protected boolean isAjax;

    public FoldableBoxFragment(WebDriver driver, WebElement element) {
        super(driver, element);
    }

    public void setAjax(boolean ajax) {
        this.isAjax = ajax;
    }

    public boolean isAjax() {
        return this.isAjax;
    }

    public void open() {
        try {
            this.element.findElement(By.xpath((String)("//div[@id='" + this.id + "']//h3[contains(@class, 'folded') and not(contains(@class, 'unfolded'))]/a[@class='foldableHeaderLink']"))).click();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void close() {
        try {
            this.element.findElement(By.xpath((String)("//div[@id='" + this.id + "']//h3[contains(@class, 'unfolded')]/a[@class='foldableHeaderLink']"))).click();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void edit() {
        this.element.findElement(By.linkText((String)"Edit")).click();
        AbstractTest.waitUntilElementPresent((By)By.xpath((String)"//h3/a[text()='Cancel']"));
        this.refreshElement();
        this.waitUntilElementPresent(By.className((String)"buttonsGadget"));
    }

    public void save() {
        this.element.findElement(By.xpath((String)"//p[@class='buttonsGadget']/input[@value='Save']")).click();
        if (this.isAjax) {
            AbstractTest.waitUntilElementPresent((By)By.xpath((String)("//div[@id='" + this.id + "']//a[text()='Edit']")));
            this.refreshElement();
        }
    }

    protected void refreshElement() {
        this.element = this.driver.findElement(By.id((String)this.id));
    }

    public WebElement waitUntilElementPresent(final By locator) {
        FluentWait wait = new FluentWait((Object)this.driver).withTimeout(30L, TimeUnit.SECONDS).pollingEvery(1L, TimeUnit.SECONDS).ignoring(NoSuchElementException.class);
        return (WebElement)wait.until((Function)new Function<WebDriver, WebElement>(){

            public WebElement apply(WebDriver driver) {
                return FoldableBoxFragment.this.element.findElement(locator);
            }
        });
    }
}

