/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.functionaltests.dam;

import org.nuxeo.functionaltests.Required;
import org.nuxeo.functionaltests.forms.WidgetElement;
import org.nuxeo.functionaltests.fragment.WebFragmentImpl;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.openqa.selenium.support.ui.Select;

public class SearchFormFragment
extends WebFragmentImpl {
    @Required
    @FindBy(id="nxl_gridDamLayout:nxw_damSearchesSelector_form:nxw_damSearchesSelector")
    public WebElement searchSelector;
    public static final String FORM_ID = "nxl_gridDamLayout:nxw_damSearchLayout_form:";
    public static final String LAYOUT_ID = "nxl_gridDamLayout:nxw_damSearchLayout_form:nxl_dam_search_layout:";
    @Required
    @FindBy(id="nxl_gridDamLayout:nxw_damSearchLayout_form:nxw_doc_damSearchActions_damSubmitSearch")
    public WebElement filterButton;
    @Required
    @FindBy(id="nxl_gridDamLayout:nxw_damSearchLayout_form:nxw_doc_damSearchActions_damClearSearch")
    public WebElement clearButton;
    @Required
    @FindBy(id="nxl_gridDamLayout:nxw_damSearchLayout_form:nxl_dam_search_layout:nxw_ecm_fulltext")
    public WebElement textInput;
    @Required
    @FindBy(id="nxl_gridDamLayout:nxw_damSearchLayout_form:nxl_dam_search_layout:nxw_damc_author")
    public WebElement originalAuthorInput;
    @Required
    @FindBy(id="nxl_gridDamLayout:nxw_damSearchLayout_form:nxl_dam_search_layout:nxw_damc_authoringDate_startInputDate")
    public WebElement authoringDateFromInput;
    @Required
    @FindBy(id="nxl_gridDamLayout:nxw_damSearchLayout_form:nxl_dam_search_layout:nxw_damc_authoringDate_endInputDate")
    public WebElement authoringDateToInput;

    public SearchFormFragment(WebDriver driver, WebElement element) {
        super(driver, element);
    }

    public String getSelectedContentView() {
        return new Select(this.searchSelector).getFirstSelectedOption().getText();
    }

    public void doSearch() {
        this.filterButton.click();
    }

    public void clearSearch() {
        this.clearButton.click();
    }

    public void fillText(String text) {
        this.textInput.clear();
        this.textInput.sendKeys(new CharSequence[]{text});
    }

    public void fillOriginalAuthor(String author) {
        new WidgetElement(this.driver, this.originalAuthorInput).setInputValue(author);
    }

    public void fillAuthoringDate(String from, String to) {
        new WidgetElement(this.driver, this.authoringDateFromInput).setInputValue(from);
        new WidgetElement(this.driver, this.authoringDateToInput).setInputValue(to);
    }
}

