/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.dam.operations;

import java.io.IOException;
import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.dam.AssetLibrary;
import org.nuxeo.dam.DamService;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.util.BlobList;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.RecoverableClientException;
import org.nuxeo.ecm.core.api.VersioningOption;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.core.api.pathsegment.PathSegmentService;
import org.nuxeo.ecm.platform.filemanager.api.FileManager;
import org.nuxeo.ecm.platform.filemanager.utils.FileManagerUtils;
import org.nuxeo.runtime.api.Framework;

@Operation(id="Dam.Import", category="Dam", label="Create Asset(s) from file(s)", description="Create Asset(s) from Blob(s) inside the configured Asset Library or the current document. Create documents using the given document type if not null, otherwise relies on the FileManagerService")
public class DamImport {
    public static final String ID = "Dam.Import";
    protected static final String SKIP_UPDATE_AUDIT_LOGGING = "org.nuxeo.filemanager.skip.audit.logging.forupdates";
    protected static final String DISABLE_AUDIT_LOGGER = "disableAuditLogger";
    @Context
    protected OperationContext ctx;
    @Context
    protected CoreSession session;
    @Context
    protected FileManager fileManager;
    @Context
    protected DamService damService;
    @Context
    protected OperationContext context;
    @Context
    protected AutomationService as;
    @Param(name="overwrite", required=false)
    protected Boolean overwrite = false;
    @Param(name="importInCurrentDocument", required=false)
    protected Boolean importInCurrentDocument = false;
    @Param(name="docType", required=false)
    protected String docType;

    protected DocumentModel getCurrentDocument() throws Exception {
        String cdRef = (String)this.context.get((Object)"currentDocument");
        return (DocumentModel)this.as.getAdaptedValue(this.context, (Object)cdRef, DocumentModel.class);
    }

    @OperationMethod
    public DocumentModel run(Blob blob) throws Exception {
        DocumentModel doc;
        AssetLibrary assetLibrary = this.damService.getAssetLibrary();
        String title = assetLibrary.getTitle();
        String path = assetLibrary.getPath();
        if (this.importInCurrentDocument.booleanValue() && (doc = this.getCurrentDocument()) != null) {
            title = doc.getTitle();
            path = doc.getPathAsString();
        }
        try {
            doc = StringUtils.isBlank((String)this.docType) ? this.fileManager.createDocumentFromBlob(this.session, blob, path, this.overwrite.booleanValue(), blob.getFilename()) : this.createDocument(blob, path);
            this.ctx.put("AddMessage.messageParams", (Object)new Object[]{1});
            return doc;
        }
        catch (ClientException e) {
            String[] params = new String[]{blob.getFilename(), title};
            throw new RecoverableClientException("Cannot import asset", "label.dam.import.asset.error", params, (Throwable)e);
        }
    }

    protected DocumentModel createDocument(Blob blob, String path) throws ClientException {
        DocumentModel doc = FileManagerUtils.getExistingDocByFileName((CoreSession)this.session, (String)path, (String)blob.getFilename());
        boolean skipCheckInAfterAdd = false;
        if (this.overwrite.booleanValue() && doc != null) {
            if (!this.skipCheckInForBlob(this.getBlob(doc))) {
                this.checkIn(doc);
            }
            this.updateDocument(doc, blob);
            if (Framework.isBooleanPropertyTrue((String)SKIP_UPDATE_AUDIT_LOGGING)) {
                doc.putContextData(DISABLE_AUDIT_LOGGER, (Serializable)Boolean.valueOf(true));
            }
            doc = doc.getCoreSession().saveDocument(doc);
        } else {
            doc = this.session.createDocumentModel(this.docType);
            doc.setPropertyValue("dc:title", (Serializable)((Object)blob.getFilename()));
            PathSegmentService pss = (PathSegmentService)Framework.getLocalService(PathSegmentService.class);
            doc.setPathInfo(path, pss.generatePathSegment(doc));
            this.updateDocument(doc, blob);
            skipCheckInAfterAdd = this.skipCheckInForBlob(blob);
            ((BlobHolder)doc.getAdapter(BlobHolder.class)).setBlob(blob);
            doc = this.session.createDocument(doc);
        }
        if (!skipCheckInAfterAdd) {
            this.checkInAfterAdd(doc);
        }
        this.session.save();
        return doc;
    }

    protected Blob getBlob(DocumentModel doc) throws ClientException {
        return ((BlobHolder)doc.getAdapter(BlobHolder.class)).getBlob();
    }

    protected boolean skipCheckInForBlob(Blob blob) {
        return blob == null || blob.getLength() == 0L;
    }

    protected void checkIn(DocumentModel doc) throws ClientException {
        VersioningOption option = this.fileManager.getVersioningOption();
        if (option != null && option != VersioningOption.NONE && doc.isCheckedOut()) {
            doc.checkIn(option, null);
        }
    }

    protected void updateDocument(DocumentModel doc, Blob blob) throws ClientException {
        try {
            blob = blob.persist();
        }
        catch (IOException e) {
            throw new ClientException((Throwable)e);
        }
        ((BlobHolder)doc.getAdapter(BlobHolder.class)).setBlob(blob);
    }

    protected void checkInAfterAdd(DocumentModel doc) throws ClientException {
        if (this.fileManager.doVersioningAfterAdd()) {
            this.checkIn(doc);
        }
    }

    @OperationMethod
    public DocumentModelList run(BlobList blobs) throws Exception {
        DocumentModelListImpl result = new DocumentModelListImpl();
        for (Blob blob : blobs) {
            result.add((Object)this.run(blob));
        }
        this.ctx.put("AddMessage.messageParams", (Object)new Object[]{result.size()});
        return result;
    }
}

