/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.dam.platform.context;

import java.io.File;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.faces.application.FacesMessage;
import javax.faces.model.SelectItem;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.contexts.Context;
import org.jboss.seam.core.Events;
import org.jboss.seam.faces.FacesMessages;
import org.nuxeo.common.utils.Path;
import org.nuxeo.dam.DamService;
import org.nuxeo.dam.importer.core.DamImporterExecutor;
import org.nuxeo.dam.importer.core.MetadataFileHelper;
import org.nuxeo.dam.importer.core.helper.UnrestrictedSessionRunnerHelper;
import org.nuxeo.dam.platform.context.ContainerFolderCreator;
import org.nuxeo.dam.webapp.chainselect.ChainSelectCleaner;
import org.nuxeo.dam.webapp.filter.FilterActions;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.impl.blob.FileBlob;
import org.nuxeo.ecm.platform.importer.properties.MetadataFile;
import org.nuxeo.ecm.platform.importer.source.FileWithMetadataSourceNode;
import org.nuxeo.ecm.platform.ui.web.tag.fn.Functions;
import org.nuxeo.ecm.webapp.helpers.ResourcesAccessor;
import org.nuxeo.ecm.webapp.querymodel.QueryModelActions;
import org.nuxeo.runtime.api.Framework;
import org.richfaces.event.UploadEvent;
import org.richfaces.model.UploadItem;

@Name(value="importActions")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=10)
public class ImportActions
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String ASYNCHRONOUS_IMPORT_PROPERTY = "org.nuxeo.dam.import.async";
    protected static final Log log = LogFactory.getLog(ImportActions.class);
    protected DocumentModel newImportSet;
    @In(create=true)
    private transient NuxeoPrincipal currentNuxeoPrincipal;
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    @In(create=true, required=false)
    protected FacesMessages facesMessages;
    @In(create=true, required=false)
    protected ResourcesAccessor resourcesAccessor;
    @In(create=true)
    protected Context eventContext;
    @In(create=true)
    protected transient QueryModelActions queryModelActions;
    @In(create=true)
    protected transient FilterActions filterActions;
    protected Blob blob;
    protected String importFolderId;
    protected String newImportFolder;

    public DocumentModel getNewImportSet() throws ClientException {
        if (this.newImportSet == null) {
            this.newImportSet = this.documentManager.createDocumentModel("ImportSet");
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd HH:mm");
            Calendar calendar = Calendar.getInstance();
            String fullName = this.currentNuxeoPrincipal != null ? Functions.principalFullName((NuxeoPrincipal)this.currentNuxeoPrincipal) : Functions.principalFullName((NuxeoPrincipal)((NuxeoPrincipal)this.documentManager.getPrincipal()));
            String defaultTitle = fullName + " - " + simpleDateFormat.format(calendar.getTime());
            this.newImportSet.setPropertyValue("dc:title", (Serializable)((Object)defaultTitle));
        }
        return this.newImportSet;
    }

    protected DocumentModel createContainerFolder(String title) throws ClientException {
        ContainerFolderCreator cfc = new ContainerFolderCreator(this.documentManager.getRepositoryName(), title);
        UnrestrictedSessionRunnerHelper.runInNewThread((UnrestrictedSessionRunner)cfc);
        Events.instance().raiseEvent("folderListChanged", new Object[0]);
        return this.documentManager.getDocument(cfc.folder.getRef());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createImportSet() throws Exception {
        String title = (String)this.newImportSet.getProperty("dublincore", "title");
        if (title == null) {
            title = "";
        }
        String tmpDirectory = System.getProperty("java.io.tmpdir");
        Path tmpPath = new Path(tmpDirectory).append("import_" + System.nanoTime());
        de.schlichtherle.io.File outDir = new de.schlichtherle.io.File(tmpPath.toString());
        outDir.mkdirs();
        MetadataFile mdFile = MetadataFileHelper.createFrom((DocumentModel)this.newImportSet);
        String principalName = this.documentManager.getPrincipal().getName();
        mdFile.addProperty("dc:creator", (Object)principalName);
        mdFile.addProperty("dc:contributors", (Object)new String[]{principalName});
        mdFile.writeTo((File)new de.schlichtherle.io.File((File)outDir, FileWithMetadataSourceNode.METADATA_FILENAME));
        File tmp = null;
        try {
            String extension = null;
            String filename = this.blob.getFilename();
            if (filename.contains(".")) {
                extension = filename.substring(filename.lastIndexOf("."));
            }
            tmp = de.schlichtherle.io.File.createTempFile((String)"import", extension);
            de.schlichtherle.io.File archive = new de.schlichtherle.io.File(tmp);
            this.blob.transferTo((File)archive);
            if (archive.isArchive()) {
                archive.archiveCopyAllTo((File)outDir);
            } else {
                archive.copyTo((File)new de.schlichtherle.io.File((File)outDir, this.blob.getFilename()));
            }
        }
        finally {
            if (this.blob != null) {
                ((FileBlob)this.blob).getFile().delete();
            }
            if (tmp != null) {
                tmp.delete();
            }
        }
        DocumentModel importFolder = this.getOrCreateImportFolder(title);
        boolean interactiveMode = !Boolean.parseBoolean(Framework.getProperty((String)ASYNCHRONOUS_IMPORT_PROPERTY, (String)"false"));
        try {
            DamImporterExecutor importer = new DamImporterExecutor(outDir.getAbsolutePath(), importFolder.getPathAsString(), title, interactiveMode, true);
            importer.run();
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
        if (interactiveMode) {
            List<SelectItem> userImportSetsSelectItems;
            this.documentManager.save();
            this.sendImportSetCreationEvent();
            this.invalidateImportContext();
            if (this.filterActions != null && (userImportSetsSelectItems = this.filterActions.getUserImportSetsSelectItems()) != null && !userImportSetsSelectItems.isEmpty()) {
                String folderPath = (String)userImportSetsSelectItems.get(0).getValue();
                DocumentModel filterDocument = this.filterActions.getFilterDocument();
                if (filterDocument != null) {
                    filterDocument.setPropertyValue("filter_query:ecm_path", (Serializable)((Object)folderPath));
                }
            }
        }
    }

    protected DocumentModel getOrCreateImportFolder(String title) throws ClientException {
        DocumentModel importFolder;
        if (this.importFolderId == null) {
            String importFolderTitle = this.newImportFolder != null && this.newImportFolder.trim().length() > 0 ? this.newImportFolder : title;
            importFolder = this.createContainerFolder(importFolderTitle);
            this.importFolderId = importFolder.getId();
        } else {
            importFolder = this.documentManager.getDocument((DocumentRef)new IdRef(this.importFolderId));
        }
        return importFolder;
    }

    protected void sendImportSetCreationEvent() {
        Events.instance().raiseEvent("importSetCreated", new Object[0]);
        this.logDocumentWithTitle("document_saved", "Created the document: ", this.newImportSet);
    }

    public void uploadListener(UploadEvent event) throws Exception {
        UploadItem item = event.getUploadItem();
        this.blob = new FileBlob(item.getFile());
        this.blob.setFilename(FilenameUtils.getName((String)item.getFileName()));
    }

    public void cancel() {
        this.invalidateImportContext();
    }

    public void invalidateImportContext() {
        this.newImportSet = null;
        this.newImportFolder = null;
        this.importFolderId = null;
        ChainSelectCleaner.cleanup("importset_form:nxl_importset:nxl_importset_left:nxw_coverage:nxw_coverage_editselect");
        ChainSelectCleaner.cleanup("importset_form:nxl_importset:nxl_importset_right:nxw_subjects:nxw_subjects_editselect");
    }

    public void logDocumentWithTitle(String facesMessage, String someLogString, DocumentModel document) {
        this.facesMessages.add(FacesMessage.SEVERITY_INFO, (String)this.resourcesAccessor.getMessages().get(facesMessage), new Object[]{this.resourcesAccessor.getMessages().get(this.newImportSet.getType())});
        if (null != document) {
            log.trace((Object)('[' + this.getClass().getSimpleName() + "] " + someLogString + ' ' + document.getId()));
            log.debug((Object)("CURRENT DOC PATH: " + document.getPathAsString()));
        } else {
            log.trace((Object)('[' + this.getClass().getSimpleName() + "] " + someLogString + " NULL DOC"));
        }
    }

    public List<SelectItem> getImportFolders() throws ClientException {
        ArrayList<SelectItem> items = new ArrayList<SelectItem>();
        DamService damService = (DamService)Framework.getLocalService(DamService.class);
        String assetLibraryPath = damService.getAssetLibraryPath();
        if (this.documentManager.hasPermission((DocumentRef)new PathRef(assetLibraryPath), "AddChildren")) {
            items.add(new SelectItem(null, (String)this.resourcesAccessor.getMessages().get("label.widget.newFolder")));
        }
        DocumentModelList docs = this.queryModelActions.get("IMPORT_FOLDERS").getDocuments(this.documentManager, new Object[]{assetLibraryPath});
        for (DocumentModel doc : docs) {
            if (!this.documentManager.hasPermission(doc.getRef(), "AddChildren")) continue;
            items.add(new SelectItem((Object)doc.getId(), doc.getTitle()));
        }
        return items;
    }

    public String getImportFolder() {
        return this.importFolderId;
    }

    public void setImportFolder(String importFolder) {
        this.importFolderId = importFolder;
    }

    public String getNewImportFolder() {
        return this.newImportFolder;
    }

    public void setNewImportFolder(String newImportFolder) {
        this.newImportFolder = newImportFolder;
    }

    public boolean getCanImport() throws ClientException {
        return !this.getImportFolders().isEmpty();
    }
}

