/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.dam.webapp;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.contexts.Context;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.faces.FacesMessages;
import org.nuxeo.dam.webapp.contentbrowser.DamDocumentActions;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.PagedDocumentsProvider;
import org.nuxeo.ecm.platform.actions.Action;
import org.nuxeo.ecm.platform.ui.web.api.WebActions;
import org.nuxeo.ecm.platform.ui.web.model.SelectDataModel;
import org.nuxeo.ecm.platform.ui.web.model.SelectDataModelRow;
import org.nuxeo.ecm.webapp.action.DeleteActions;
import org.nuxeo.ecm.webapp.clipboard.ClipboardActions;
import org.nuxeo.ecm.webapp.documentsLists.DocumentsListsManager;
import org.nuxeo.ecm.webapp.helpers.ResourcesAccessor;
import org.nuxeo.ecm.webapp.pagination.ResultsProvidersCache;

@Scope(value=ScopeType.CONVERSATION)
@Name(value="bulkSelectActions")
@Install(precedence=10)
public class BulkSelectActions
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(BulkSelectActions.class);
    protected static final String CACHED_SELECTED_DOCUMENT_IDS = "cachedSelectedDocumentIds";
    @In(create=true, required=false)
    protected CoreSession documentManager;
    @In(create=true)
    protected DocumentsListsManager documentsListsManager;
    @In(create=true)
    protected DeleteActions deleteActions;
    @In(create=true, required=false)
    protected FacesMessages facesMessages;
    @In(create=true)
    protected ResourcesAccessor resourcesAccessor;
    @In(create=true)
    protected transient WebActions webActions;
    @In(create=true)
    protected DamDocumentActions damDocumentActions;
    @In(create=true)
    protected ClipboardActions clipboardActions;
    @In(create=true)
    protected transient ResultsProvidersCache resultsProvidersCache;

    public void deleteSelection() throws ClientException {
        if (!this.documentsListsManager.isWorkingListEmpty("CURRENT_SELECTION")) {
            this.deleteActions.deleteSelection(this.documentsListsManager.getWorkingList("CURRENT_SELECTION"));
        }
    }

    public boolean getIsCurrentSelectionInWorkingList(String docId, String listName) {
        if (docId == null) {
            return false;
        }
        String lName = listName == null ? "CURRENT_SELECTION" : listName;
        Context eventContext = Contexts.getEventContext();
        HashSet<String> selectedIds = (HashSet<String>)eventContext.get(CACHED_SELECTED_DOCUMENT_IDS);
        if (selectedIds == null) {
            selectedIds = new HashSet<String>();
            List selectedDocumentsList = this.documentsListsManager.getWorkingList(lName);
            if (selectedDocumentsList != null) {
                for (DocumentModel selectedDocumentModel : selectedDocumentsList) {
                    selectedIds.add(selectedDocumentModel.getId());
                }
            }
            eventContext.set(CACHED_SELECTED_DOCUMENT_IDS, selectedIds);
        }
        return selectedIds.contains(docId);
    }

    public boolean getIsCurrentPageInWorkingList(String providerName, String listName) {
        PagedDocumentsProvider provider;
        List list = this.documentsListsManager.getWorkingList(listName = listName == null ? "CURRENT_SELECTION" : listName);
        if (list == null) {
            log.error((Object)("no registered list with name " + listName));
            return false;
        }
        try {
            provider = this.resultsProvidersCache.get(providerName);
        }
        catch (ClientException e) {
            log.error((Object)("Failed to get provider " + providerName), (Throwable)e);
            return false;
        }
        DocumentModelList documents = provider.getCurrentPage();
        return list.containsAll((Collection<?>)documents);
    }

    public void clearWorkingList(String listName) {
        String lName = listName == null ? "CURRENT_SELECTION" : listName;
        List selectedDocumentsList = this.documentsListsManager.getWorkingList(lName);
        selectedDocumentsList.clear();
    }

    public void toggleDocumentSelection(DocumentModel doc, String listName) {
        List list = this.documentsListsManager.getWorkingList(listName = listName == null ? "CURRENT_SELECTION" : listName);
        if (list == null) {
            log.error((Object)("no registered list with name " + listName));
            return;
        }
        if (list.contains(doc)) {
            this.documentsListsManager.removeFromWorkingList(listName, doc);
        } else {
            this.documentsListsManager.addToWorkingList(listName, doc);
        }
    }

    public void togglePageSelection(String providerName, String listName, SelectDataModel selectDataModel) {
        PagedDocumentsProvider provider;
        try {
            provider = this.resultsProvidersCache.get(providerName);
        }
        catch (ClientException e) {
            log.error((Object)("Failed to get provider " + providerName), (Throwable)e);
            return;
        }
        DocumentModelList documents = provider.getCurrentPage();
        listName = listName == null ? "CURRENT_SELECTION" : listName;
        List list = this.documentsListsManager.getWorkingList(listName);
        if (list == null) {
            log.error((Object)("no registered list with name " + listName));
            return;
        }
        if (list.containsAll((Collection<?>)documents)) {
            this.documentsListsManager.removeFromWorkingList(listName, (List)documents);
            for (SelectDataModelRow row : selectDataModel.getRows()) {
                row.setSelected(Boolean.valueOf(false));
            }
        } else {
            this.documentsListsManager.addToWorkingList(listName, (List)documents);
            for (SelectDataModelRow row : selectDataModel.getRows()) {
                row.setSelected(Boolean.valueOf(true));
            }
        }
    }

    public boolean getCanEditAssets() throws ClientException {
        if (!this.getIsSelectionNotEmpty()) {
            return false;
        }
        List docs = this.documentsListsManager.getWorkingList("CURRENT_SELECTION");
        for (DocumentModel doc : docs) {
            if (this.documentManager.hasPermission(doc.getRef(), "Write")) continue;
            return false;
        }
        return true;
    }

    public boolean getIsSelectionNotEmpty() {
        List docs = this.documentsListsManager.getWorkingList("CURRENT_SELECTION");
        return docs != null && !docs.isEmpty();
    }

    public void exportSelection() throws ClientException {
        if (!this.documentsListsManager.isWorkingListEmpty("CURRENT_SELECTION")) {
            this.exportSelection(this.documentsListsManager.getWorkingList("CURRENT_SELECTION"));
        }
    }

    public String exportSelection(List<DocumentModel> docsToExport) throws ClientException {
        if (docsToExport != null && !docsToExport.isEmpty()) {
            return this.clipboardActions.exportWorklistAsZip(docsToExport, false);
        }
        return null;
    }

    public List<Action> getActionsForSelection() {
        return this.webActions.getUnfiltredActionsList("DAM_CURRENT_SELECTION_LIST");
    }

    public List<Action> getActionsForSelectionNoAjax() {
        return this.webActions.getUnfiltredActionsList("DAM_CURRENT_SELECTION_NOA4J_LIST");
    }

    public List<Action> getHrefActionsForSelection() {
        return this.webActions.getUnfiltredActionsList("DAM_CURRENT_SELECTION_LIST_HREF");
    }
}

