/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.dam.webapp.fileimporter;

import de.schlichtherle.io.FileInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.impl.blob.StreamingBlob;
import org.nuxeo.ecm.platform.filemanager.api.FileManager;
import org.nuxeo.ecm.platform.filemanager.service.extension.AbstractFileImporter;
import org.nuxeo.ecm.platform.types.TypeManager;
import org.nuxeo.runtime.api.Framework;

public class ArchiveImporter
extends AbstractFileImporter {
    private static final long serialVersionUID = 1L;
    protected static final Log log = LogFactory.getLog(ArchiveImporter.class);
    protected static final List<Pattern> ignorePatterns = Arrays.asList(Pattern.compile("__MACOSX"), Pattern.compile("\\.DS_Store"));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocumentModel create(CoreSession documentManager, Blob content, String path, boolean overwrite, String filename, TypeManager typeService) throws ClientException, IOException {
        block7: {
            DocumentModel doc = documentManager.getDocument((DocumentRef)new PathRef(path));
            if (!"ImportFolder".equals(doc.getType())) {
                return null;
            }
            String extension = FilenameUtils.getExtension((String)filename);
            File tmp = de.schlichtherle.io.File.createTempFile((String)"import", (String)extension);
            try {
                de.schlichtherle.io.File archive = new de.schlichtherle.io.File(tmp);
                content.transferTo((File)archive);
                if (!archive.isArchive()) break block7;
                try {
                    FileManager fileManager = (FileManager)Framework.getService(FileManager.class);
                    for (File entry : archive.listFiles()) {
                        this.importFileRec(documentManager, entry, path, overwrite, fileManager);
                    }
                }
                catch (Exception e) {
                    throw new ClientException("Failed to import archive: " + e.getMessage(), (Throwable)e);
                }
            }
            finally {
                tmp.delete();
            }
        }
        return documentManager.getDocument((DocumentRef)new PathRef(path));
    }

    protected void importFileRec(CoreSession documentManager, File file, String path, boolean overwrite, FileManager fileManager) throws Exception {
        for (Pattern pattern : ignorePatterns) {
            if (!pattern.matcher(file.getName()).matches()) continue;
            return;
        }
        try {
            if (file.isDirectory()) {
                DocumentModel folder = fileManager.createFolder(documentManager, file.getName(), path);
                for (File child : file.listFiles()) {
                    this.importFileRec(documentManager, child, folder.getPathAsString(), overwrite, fileManager);
                }
            } else {
                FileInputStream is = new FileInputStream(file);
                StreamingBlob blob = StreamingBlob.createFromStream((InputStream)is);
                blob.setFilename(file.getName());
                fileManager.createDocumentFromBlob(documentManager, (Blob)blob, path, overwrite, file.getName());
            }
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
    }
}

