/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.dam.webapp.filter;

import java.io.Serializable;
import java.util.List;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.contexts.Contexts;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.PagedDocumentsProvider;
import org.nuxeo.ecm.platform.ui.web.model.SelectDataModel;
import org.nuxeo.ecm.platform.ui.web.model.SelectDataModelListener;
import org.nuxeo.ecm.platform.ui.web.model.impl.SelectDataModelImpl;
import org.nuxeo.ecm.platform.ui.web.model.impl.SelectDataModelRowEvent;
import org.nuxeo.ecm.webapp.documentsLists.DocumentsListsManager;
import org.nuxeo.ecm.webapp.pagination.ResultsProvidersCache;

@Name(value="filterResults")
@Scope(value=ScopeType.CONVERSATION)
public class FilterResults
implements SelectDataModelListener,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SEARCH_DOCUMENT_LIST = "SEARCH_DOCUMENT_LIST";
    public static final String FILTERED_DOCUMENT_PROVIDER_NAME = "FILTERED_DOCUMENTS";
    public static final String FILTER_SELECT_MODEL_NAME = "filterSelectModel";
    @In(required=false, create=true)
    protected transient DocumentsListsManager documentsListsManager;
    @In(required=false, create=true)
    protected transient ResultsProvidersCache resultsProvidersCache;
    protected transient PagedDocumentsProvider provider;

    @Factory(value="filterSelectModel", scope=ScopeType.EVENT)
    public SelectDataModel getResultsSelectModelFiltered() throws ClientException {
        return this.getResultsSelectModel(FILTERED_DOCUMENT_PROVIDER_NAME);
    }

    public SelectDataModel getResultsSelectModel(String providerName) throws ClientException {
        if (providerName == null) {
            throw new ClientException("providerName has not been set yet");
        }
        List selectedDocuments = this.documentsListsManager.getWorkingList("CURRENT_SELECTION");
        SelectDataModelImpl model = new SelectDataModelImpl(SEARCH_DOCUMENT_LIST, this.getResultDocuments(providerName), selectedDocuments);
        model.addSelectModelListener((SelectDataModelListener)this);
        return model;
    }

    public List<DocumentModel> getResultDocuments(String providerName) throws ClientException {
        return this.getProvider(providerName).getCurrentPage();
    }

    public PagedDocumentsProvider getProvider(String providerName) throws ClientException {
        this.provider = this.resultsProvidersCache.get(providerName);
        if (this.provider == null) {
            throw new ClientException("Unknown or unbuildable results provider: " + providerName);
        }
        return this.provider;
    }

    public void processSelectRowEvent(SelectDataModelRowEvent event) {
        Boolean selection = event.getSelected();
        DocumentModel data = (DocumentModel)event.getRowData();
        if (selection.booleanValue()) {
            this.documentsListsManager.addToWorkingList("CURRENT_SELECTION", data);
        } else {
            this.documentsListsManager.removeFromWorkingList("CURRENT_SELECTION", data);
        }
    }

    @Observer(value={"importSetCreated"})
    public void invalidateFilterResult() {
        this.documentsListsManager.resetWorkingList("CURRENT_SELECTION");
        this.resultsProvidersCache.invalidate(FILTERED_DOCUMENT_PROVIDER_NAME);
        this.provider = null;
    }

    @Observer(value={"documentChildrenChanged"})
    public void invalidateSelectDataModel() {
        Contexts.getEventContext().remove(FILTER_SELECT_MODEL_NAME);
    }
}

