/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.client.jaxrs.spi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.automation.client.jaxrs.AdapterFactory;
import org.nuxeo.ecm.automation.client.jaxrs.AsyncCallback;
import org.nuxeo.ecm.automation.client.jaxrs.AutomationClient;
import org.nuxeo.ecm.automation.client.jaxrs.LoginInfo;
import org.nuxeo.ecm.automation.client.jaxrs.Session;
import org.nuxeo.ecm.automation.client.jaxrs.spi.Connector;
import org.nuxeo.ecm.automation.client.jaxrs.spi.DefaultSession;
import org.nuxeo.ecm.automation.client.jaxrs.spi.OperationRegistry;
import org.nuxeo.ecm.automation.client.jaxrs.spi.Request;
import org.nuxeo.ecm.automation.client.jaxrs.util.Base64;

public abstract class AbstractAutomationClient
implements AutomationClient {
    protected String url;
    protected volatile OperationRegistry registry;
    protected Map<Class<?>, List<AdapterFactory<?>>> adapters = new HashMap();

    protected AbstractAutomationClient(String url) {
        this.url = url.endsWith("/") ? url : url + "/";
    }

    @Override
    public String getBaseUrl() {
        return this.url;
    }

    protected OperationRegistry getRegistry() {
        return this.registry;
    }

    @Override
    public void registerAdapter(AdapterFactory<?> factory) {
        Class<?> adapter = factory.getAdapterType();
        List<AdapterFactory<?>> factories = this.adapters.get(adapter);
        if (factories == null) {
            factories = new ArrayList();
            this.adapters.put(adapter, factories);
        }
        factories.add(factory);
    }

    @Override
    public <T> T getAdapter(Object objToAdapt, Class<T> adapterType) {
        Class<?> cls = objToAdapt.getClass();
        List<AdapterFactory<?>> factories = this.adapters.get(adapterType);
        if (factories != null) {
            for (AdapterFactory<?> f : factories) {
                if (!f.getAcceptType().isAssignableFrom(cls)) continue;
                return (T)f.getAdapter(objToAdapt);
            }
        }
        return null;
    }

    protected synchronized void connect(String username, String password) throws Exception {
        Request req = new Request(0, this.url);
        req.put("Accept", "application/json+nxautomation");
        if (username != null) {
            String auth = "Basic " + Base64.encode(username + ":" + password);
            req.put("Authorization", auth);
        }
        this.registry = (OperationRegistry)this.newConnector().execute(req);
    }

    @Override
    public synchronized void shutdown() {
        this.url = null;
        this.registry = null;
        this.adapters = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Session getSession(String username, String password) throws Exception {
        if (this.registry == null) {
            AbstractAutomationClient abstractAutomationClient = this;
            synchronized (abstractAutomationClient) {
                if (this.registry == null) {
                    this.connect(username, password);
                }
            }
        }
        if (username != null) {
            return this.login(username, password);
        }
        return this.createSession(this.newConnector(), LoginInfo.ANONYNMOUS);
    }

    @Override
    public void getSession(final String username, final String password, final AsyncCallback<Session> cb) {
        this.asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    Session session = AbstractAutomationClient.this.getSession(username, password);
                    cb.onSuccess(session);
                }
                catch (Throwable t) {
                    cb.onError(t);
                }
            }
        });
    }

    public Session login(String username, String password) throws Exception {
        Request request = new Request(1, this.url + this.getRegistry().getPath("login"));
        String auth = "Basic " + Base64.encode(username + ":" + password);
        request.put("Authorization", auth);
        request.put("Accept", "application/json+nxentity");
        Connector connector = this.newConnector();
        connector.setBasicAuth(auth);
        LoginInfo login = (LoginInfo)connector.execute(request);
        return this.createSession(connector, login);
    }

    protected Session createSession(Connector connector, LoginInfo login) {
        return new DefaultSession(this, connector, login == null ? LoginInfo.ANONYNMOUS : login);
    }

    public void asyncExec(Runnable runnable) {
        throw new UnsupportedOperationException("Async execution not supported");
    }

    protected abstract Connector newConnector();
}

