/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.client.jaxrs.impl;

import java.util.Map;
import javax.mail.internet.MimeMultipart;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.nuxeo.ecm.automation.client.jaxrs.RemoteException;
import org.nuxeo.ecm.automation.client.jaxrs.impl.MultipartRequestEntity;
import org.nuxeo.ecm.automation.client.jaxrs.spi.Connector;
import org.nuxeo.ecm.automation.client.jaxrs.spi.Request;

public class ConnectorImpl
implements Connector {
    protected final HttpClient http;
    protected final HttpContext ctx;
    protected String basicAuth;

    public ConnectorImpl(HttpClient http) {
        this(http, (HttpContext)new BasicHttpContext());
    }

    public ConnectorImpl(HttpClient http, HttpContext ctx) {
        ctx.setAttribute("http.cookie-store", (Object)new BasicCookieStore());
        this.http = http;
        this.ctx = ctx;
    }

    @Override
    public void setBasicAuth(String auth) {
        this.basicAuth = auth;
    }

    @Override
    public String getBasicAuth() {
        return this.basicAuth;
    }

    @Override
    public Object execute(Request request) throws Exception {
        if (request.getMethod() == 1) {
            HttpPost post = new HttpPost(request.getUrl());
            Object obj = request.getEntity();
            if (obj != null) {
                MultipartRequestEntity entity = null;
                entity = request.isMultiPart() ? new MultipartRequestEntity((MimeMultipart)obj) : new StringEntity(obj.toString(), "UTF-8");
                post.setEntity((HttpEntity)entity);
            }
            return this.execute(request, (HttpUriRequest)post);
        }
        HttpGet get = new HttpGet(request.getUrl());
        return this.execute(request, (HttpUriRequest)get);
    }

    protected Object execute(Request request, HttpUriRequest httpReq) throws Exception {
        for (Map.Entry entry : request.entrySet()) {
            httpReq.setHeader((String)entry.getKey(), (String)entry.getValue());
        }
        HttpResponse resp = this.http.execute(httpReq, this.ctx);
        HttpEntity entity = resp.getEntity();
        int status = resp.getStatusLine().getStatusCode();
        if (entity == null) {
            if (status < 400) {
                return null;
            }
            throw new RemoteException(status, "ServerError", "Server Error", null);
        }
        Header ctypeHeader = entity.getContentType();
        if (ctypeHeader == null) {
            if (status != 200) {
                throw new RemoteException(status, "ServerError", "Server Error", null);
            }
            return null;
        }
        String ctype = ctypeHeader.getValue().toLowerCase();
        String disp = null;
        Header[] hdisp = resp.getHeaders("Content-Disposition");
        if (hdisp != null && hdisp.length > 0) {
            disp = hdisp[0].getValue();
        }
        return request.handleResult(status, ctype, disp, entity.getContent());
    }
}

