/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.client.jaxrs.test;

import java.io.File;
import org.nuxeo.ecm.automation.client.jaxrs.RemoteException;
import org.nuxeo.ecm.automation.client.jaxrs.Session;
import org.nuxeo.ecm.automation.client.jaxrs.impl.HttpAutomationClient;
import org.nuxeo.ecm.automation.client.jaxrs.model.Blob;
import org.nuxeo.ecm.automation.client.jaxrs.model.Document;
import org.nuxeo.ecm.automation.client.jaxrs.model.FileBlob;
import org.nuxeo.ecm.automation.client.jaxrs.model.PropertyMap;

public class TestBlob {
    public static void main(String[] args) throws Exception {
        try {
            HttpAutomationClient client = new HttpAutomationClient("http://192.168.1.200:8080/nuxeo/site/automation");
            long start = System.currentTimeMillis();
            Session session = client.getSession("Administrator", "Administrator");
            FileBlob fb = new FileBlob(new File("/Users/fermigier/Pictures/bart.jpg"));
            fb.setMimeType("image/jpeg");
            Blob blob = (Blob)session.newRequest("Blob.Attach").setHeader("X-NXVoidOperation", "true").setInput(fb).set("document", "/titi").execute();
            System.out.println(blob);
            Document doc = (Document)session.newRequest("Document.Fetch").setHeader("X-NXDocumentProperties", "*").set("value", "/default-domain/workspaces/myws/file").execute();
            System.out.println(doc);
            System.out.println(doc.getProperties().map());
            PropertyMap map = doc.getProperties().getMap("file:content");
            System.out.println("----------");
            String path = map.getString("data");
            blob = session.getFile(path);
            System.out.println(((FileBlob)blob).getFile());
            System.out.println("----------");
            System.out.println(map);
            System.out.println("took: " + ((double)System.currentTimeMillis() - (double)start) / 1000.0);
            start = System.currentTimeMillis();
            for (int i = 0; i < 60; ++i) {
                doc = (Document)session.newRequest("Document.Fetch").setHeader("X-NXDocumentProperties", "*").set("value", "/default-domain/workspaces/myws/file").execute();
            }
            System.out.println("60 full docs took: " + ((double)System.currentTimeMillis() - (double)start) / 1000.0);
            client.shutdown();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            System.out.println(e.getRemoteStackTrace());
        }
    }
}

