/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.client.jaxrs.model;

import java.util.Date;

public class DateUtils {
    public static Date parseDate(String date) {
        int t = date.indexOf(84);
        Date result = new Date(0L);
        if (t == -1) {
            DateUtils.fillDate(date, result);
        } else {
            DateUtils.fillDate(date.substring(0, t), result);
            DateUtils.fillTime(date.substring(t + 1), result);
        }
        return result;
    }

    public static String formatDate(Date date) {
        StringBuilder buf = new StringBuilder();
        int y = date.getYear() + 1900;
        int m = date.getMonth() + 1;
        int d = date.getDate();
        buf.append(y).append('-');
        if (m < 10) {
            buf.append("0");
        }
        buf.append(m).append('-');
        if (d < 10) {
            buf.append("0");
        }
        buf.append(d);
        buf.append('T');
        int h = date.getHours();
        m = date.getMinutes();
        int s = date.getSeconds();
        if (h < 10) {
            buf.append("0");
        }
        buf.append(h).append(':');
        if (m < 10) {
            buf.append("0");
        }
        buf.append(m).append(':');
        if (s < 10) {
            buf.append("0");
        }
        buf.append(s);
        buf.append('Z');
        return buf.toString();
    }

    protected static void fillDate(String text, Date date) {
        int p = text.indexOf(45);
        if (p == -1) {
            throw new IllegalArgumentException("Invalid date format: " + text);
        }
        String y = text.substring(0, p);
        int q = text.indexOf(45, p + 1);
        if (q == -1) {
            throw new IllegalArgumentException("Invalid date format: " + text);
        }
        String m = text.substring(p + 1, q);
        String d = text.substring(q + 1);
        int year = Integer.parseInt(y) - 1900;
        int month = Integer.parseInt(m) - 1;
        int day = Integer.parseInt(d);
        date.setYear(year);
        date.setMonth(month);
        date.setDate(day);
    }

    protected static void fillTime(String text, Date date) {
        int p = text.indexOf(58);
        if (p == -1) {
            throw new IllegalArgumentException("Invalid time format: " + text);
        }
        String h = text.substring(0, p);
        int q = text.indexOf(58, p + 1);
        if (q == -1) {
            throw new IllegalArgumentException("Invalid time format: " + text);
        }
        String m = text.substring(p + 1, q);
        String s = text.substring(q + 1, text.length() - 1);
        int hour = Integer.parseInt(h);
        int minute = Integer.parseInt(m);
        int second = Integer.parseInt(s);
        date.setHours(hour);
        date.setMinutes(minute);
        date.setSeconds(second);
    }

    public static void main(String[] args) {
        Date d = new Date();
        String s = DateUtils.formatDate(d);
        System.out.println(s);
        Date d2 = DateUtils.parseDate(s);
        System.out.println(d + " = " + d2);
    }
}

