/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.client.jaxrs.spi;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONNull;
import net.sf.json.JSONObject;
import org.nuxeo.ecm.automation.client.jaxrs.LoginInfo;
import org.nuxeo.ecm.automation.client.jaxrs.OperationRequest;
import org.nuxeo.ecm.automation.client.jaxrs.RemoteException;
import org.nuxeo.ecm.automation.client.jaxrs.model.Document;
import org.nuxeo.ecm.automation.client.jaxrs.model.Documents;
import org.nuxeo.ecm.automation.client.jaxrs.model.OperationDocumentation;
import org.nuxeo.ecm.automation.client.jaxrs.model.OperationInput;
import org.nuxeo.ecm.automation.client.jaxrs.model.PropertyList;
import org.nuxeo.ecm.automation.client.jaxrs.model.PropertyMap;
import org.nuxeo.ecm.automation.client.jaxrs.spi.OperationRegistry;
import org.nuxeo.ecm.automation.client.jaxrs.util.JSONExporter;

public class JsonMarshalling {
    public static OperationRegistry readRegistry(String content) {
        JSONObject pathsObj;
        OperationDocumentation op;
        JSONObject obj;
        int i;
        int len;
        JSONObject json = JSONObject.fromObject((Object)content);
        HashMap<String, OperationDocumentation> ops = new HashMap<String, OperationDocumentation>();
        HashMap<String, OperationDocumentation> chains = new HashMap<String, OperationDocumentation>();
        HashMap<String, String> paths = new HashMap<String, String>();
        JSONArray ar = json.getJSONArray("operations");
        if (ar != null) {
            len = ar.size();
            for (i = 0; i < len; ++i) {
                obj = ar.getJSONObject(i);
                op = JSONExporter.fromJSON(obj);
                ops.put(op.id, op);
            }
        }
        if ((ar = json.getJSONArray("chains")) != null) {
            len = ar.size();
            for (i = 0; i < len; ++i) {
                obj = ar.getJSONObject(i);
                op = JSONExporter.fromJSON(obj);
                chains.put(op.id, op);
            }
        }
        if ((pathsObj = json.getJSONObject("paths")) != null) {
            Iterator it = pathsObj.keys();
            while (it.hasNext()) {
                String key = (String)it.next();
                String value = pathsObj.getString(key);
                paths.put(key, value);
            }
        }
        return new OperationRegistry(paths, ops, chains);
    }

    public static Object readEntity(String content) {
        if (content.length() == 0) {
            return null;
        }
        JSONObject json = JSONObject.fromObject((Object)content);
        String type = json.getString("entity-type");
        if ("document".equals(type)) {
            return JsonMarshalling.readDocument(json);
        }
        if ("documents".equals(type)) {
            JSONArray ar = json.getJSONArray("entries");
            int size = ar.size();
            Documents docs = new Documents(size);
            for (int i = 0; i < size; ++i) {
                JSONObject obj = ar.getJSONObject(i);
                docs.add(JsonMarshalling.readDocument(obj));
            }
            return docs;
        }
        if ("login".equals(type)) {
            return JsonMarshalling.readLogin(json);
        }
        if ("exception".equals(type)) {
            throw JsonMarshalling.readException(content);
        }
        throw new IllegalArgumentException("Unknown entity type: " + type);
    }

    public static RemoteException readException(String content) {
        return JsonMarshalling.readException(JSONObject.fromObject((Object)content));
    }

    protected static RemoteException readException(JSONObject json) {
        return new RemoteException(Integer.parseInt(json.getString("status")), json.optString("type", null), json.optString("message"), json.optString("stack", null));
    }

    protected static LoginInfo readLogin(JSONObject json) {
        String username = json.getString("username");
        String isAdmin = json.optString("isAdministrator", "false");
        JSONArray groups = json.optJSONArray("groups");
        HashSet<String> set = new HashSet<String>();
        if (groups != null) {
            int size = groups.size();
            for (int i = 0; i < size; ++i) {
                set.add(groups.getString(i));
            }
        }
        return new LoginInfo(username, set, Boolean.parseBoolean(isAdmin));
    }

    protected static Document readDocument(JSONObject json) {
        String uid = json.getString("uid");
        String path = json.getString("path");
        String type = json.getString("type");
        String state = json.optString("state", null);
        String lock = json.optString("lock", null);
        String title = json.optString("title", null);
        String lastModified = json.optString("lastModified", null);
        JSONObject jsonProps = json.optJSONObject("properties");
        PropertyMap props = jsonProps != null ? (PropertyMap)JsonMarshalling.readValue(jsonProps) : new PropertyMap();
        props.set("dc:title", title);
        props.set("dc:modified", lastModified);
        return new Document(uid, type, path, state, lock, props);
    }

    protected static Object readValue(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof JSON) {
            JSON jo = (JSON)o;
            if (jo == JSONNull.getInstance()) {
                return null;
            }
            if (jo.isArray()) {
                JSONArray ar = (JSONArray)jo;
                PropertyList plist = new PropertyList();
                List<Object> list = plist.list();
                int size = ar.size();
                for (int i = 0; i < size; ++i) {
                    Object v = JsonMarshalling.readValue(ar.get(i));
                    if (v == null) continue;
                    list.add(v);
                }
                return plist;
            }
            JSONObject ob = (JSONObject)jo;
            if (ob.isNullObject()) {
                return null;
            }
            PropertyMap pmap = new PropertyMap();
            Map<String, Object> map = pmap.map();
            Iterator keys = ob.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                Object v = JsonMarshalling.readValue(ob.get(key));
                map.put(key, v);
            }
            return pmap;
        }
        return o.toString();
    }

    public static String writeRequest(OperationRequest req) throws Exception {
        String ref;
        JSONObject entity = new JSONObject();
        OperationInput input = req.getInput();
        if (input != null && !input.isBinary() && (ref = input.getInputRef()) != null) {
            entity.element("input", (Object)ref);
        }
        entity.element("params", req.getParameters());
        entity.element("context", req.getContextParameters());
        return entity.toString();
    }
}

