/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.client.jaxrs.util;

public class Base64 {
    private static final String ALPHABET = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
    private static final String PAD = "=";
    private static final int[] BSHIFT = new int[]{24, 16, 8, 0};

    public static String encode(int[] arr, int byteLen) {
        return Base64.encode(Base64.toByteArray(arr, byteLen));
    }

    protected static byte[] toByteArray(int[] arr, int byteLen) {
        byte[] bytes = new byte[byteLen];
        int l = Math.min(arr.length * 4, byteLen);
        int i = 0;
        for (int b = 0; b < l; ++b) {
            bytes[b] = (byte)(arr[i] >> BSHIFT[b & 3] & 0xFF);
        }
        return bytes;
    }

    public static String encode(String value) {
        return Base64.encode(Base64.stringToBytes(value));
    }

    public static String encode(byte[] arr) {
        StringBuilder sb = new StringBuilder();
        int l = arr.length;
        int m = l % 3;
        l -= m;
        for (int i = 0; i < l; i += 3) {
            Base64.encodeTriplet(sb, arr, i, 3);
        }
        if (m == 2) {
            Base64.encodeTriplet(sb, arr, l, 2);
        } else if (m == 1) {
            Base64.encodeTriplet(sb, arr, l, 1);
        }
        return sb.toString();
    }

    private static void encodeTriplet(StringBuilder sb, byte[] array, int index, int len) {
        int triplet = (array[index] & 0xFF) << 16;
        if (len >= 2) {
            triplet |= (array[index + 1] & 0xFF) << 8;
        }
        if (len >= 3) {
            triplet |= array[index + 2] & 0xFF;
        }
        int pad = 3 - len;
        for (int j = 3; j >= pad; --j) {
            int p = triplet >> j * 6 & 0x3F;
            sb.append(ALPHABET.charAt(p));
        }
        while (pad-- > 0) {
            sb.append(PAD);
        }
    }

    public static byte[] stringToBytes(String msg) {
        int len = msg.length();
        byte[] bytes = new byte[len];
        for (int i = 0; i < len; ++i) {
            bytes[i] = (byte)(msg.charAt(i) & 0xFF);
        }
        return bytes;
    }
}

