/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.client.jaxrs.spi;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.client.jaxrs.spi.AbstractAutomationClient;

public abstract class AsyncAutomationClient
extends AbstractAutomationClient {
    private static final Log log = LogFactory.getLog(AsyncAutomationClient.class);
    protected ExecutorService async;

    public AsyncAutomationClient(String url) {
        this(url, Executors.newCachedThreadPool(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread("AutomationAsyncExecutor");
            }
        }));
    }

    public AsyncAutomationClient(String url, ExecutorService executor) {
        super(url);
        this.async = executor;
    }

    @Override
    public void asyncExec(Runnable runnable) {
        this.async.execute(runnable);
    }

    @Override
    public synchronized void shutdown() {
        try {
            this.async.awaitTermination(2L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            log.error((Object)e, (Throwable)e);
        }
        super.shutdown();
        this.async = null;
    }
}

