/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.client.jaxrs.spi;

import java.util.HashMap;
import java.util.Iterator;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.nuxeo.ecm.automation.client.jaxrs.OperationRequest;
import org.nuxeo.ecm.automation.client.jaxrs.model.OperationDocumentation;
import org.nuxeo.ecm.automation.client.jaxrs.model.OperationInput;
import org.nuxeo.ecm.automation.client.jaxrs.spi.JsonMarshaller;
import org.nuxeo.ecm.automation.client.jaxrs.spi.OperationRegistry;
import org.nuxeo.ecm.automation.client.jaxrs.spi.marshallers.DateMarshaller;
import org.nuxeo.ecm.automation.client.jaxrs.spi.marshallers.DocumentMarshaller;
import org.nuxeo.ecm.automation.client.jaxrs.spi.marshallers.DocumentsMarshaller;
import org.nuxeo.ecm.automation.client.jaxrs.spi.marshallers.ExceptionMarshaller;
import org.nuxeo.ecm.automation.client.jaxrs.spi.marshallers.LoginMarshaller;
import org.nuxeo.ecm.automation.client.jaxrs.spi.marshallers.PrimitiveMarshaller;
import org.nuxeo.ecm.automation.client.jaxrs.util.JSONExporter;

public class JsonMarshalling {
    protected static final HashMap<String, JsonMarshaller<?>> marshallersByType = new HashMap();
    protected static final HashMap<Class<?>, JsonMarshaller<?>> marshallersByJavaType = new HashMap();

    private JsonMarshalling() {
    }

    public static void addMarshaller(JsonMarshaller<?> marshaller) {
        marshallersByType.put(marshaller.getType(), marshaller);
        marshallersByJavaType.put(marshaller.getJavaType(), marshaller);
    }

    public static <T> JsonMarshaller<T> getMarshaller(String type) {
        return marshallersByType.get(type);
    }

    public static <T> JsonMarshaller<T> getMarshaller(Class<T> clazz) {
        return marshallersByJavaType.get(clazz);
    }

    protected static JsonMarshaller<?> findMarshaller(JSONObject json) {
        String type = json.getString("entity-type");
        JsonMarshaller<?> js = marshallersByType.get(type);
        if (js == null) {
            throw new IllegalArgumentException("no marshaller for " + type);
        }
        return js;
    }

    public static OperationRegistry readRegistry(String content) {
        JSONObject pathsObj;
        OperationDocumentation op;
        JSONObject obj;
        int i;
        int len;
        JSONObject json = JSONObject.fromObject((Object)content);
        HashMap<String, OperationDocumentation> ops = new HashMap<String, OperationDocumentation>();
        HashMap<String, OperationDocumentation> chains = new HashMap<String, OperationDocumentation>();
        HashMap<String, String> paths = new HashMap<String, String>();
        JSONArray ar = json.getJSONArray("operations");
        if (ar != null) {
            len = ar.size();
            for (i = 0; i < len; ++i) {
                obj = ar.getJSONObject(i);
                op = JSONExporter.fromJSON(obj);
                ops.put(op.id, op);
            }
        }
        if ((ar = json.getJSONArray("chains")) != null) {
            len = ar.size();
            for (i = 0; i < len; ++i) {
                obj = ar.getJSONObject(i);
                op = JSONExporter.fromJSON(obj);
                chains.put(op.id, op);
            }
        }
        if ((pathsObj = json.getJSONObject("paths")) != null) {
            Iterator it = pathsObj.keys();
            while (it.hasNext()) {
                String key = (String)it.next();
                String value = pathsObj.getString(key);
                paths.put(key, value);
            }
        }
        return new OperationRegistry(paths, ops, chains);
    }

    public static Object readEntity(String content) {
        if (content.length() == 0) {
            return null;
        }
        JSONObject json = JSONObject.fromObject((Object)content);
        JsonMarshaller<?> marshaller = JsonMarshalling.findMarshaller(json);
        return marshaller.read(json);
    }

    public static String writeRequest(OperationRequest req) throws Exception {
        String ref;
        JSONObject entity = new JSONObject();
        OperationInput input = req.getInput();
        if (input != null && !input.isBinary() && (ref = input.getInputRef()) != null) {
            entity.element("input", (Object)ref);
        }
        entity.element("params", req.getParameters());
        entity.element("context", req.getContextParameters());
        return entity.toString();
    }

    static {
        JsonMarshalling.addMarshaller(new DocumentMarshaller());
        JsonMarshalling.addMarshaller(new DocumentsMarshaller());
        JsonMarshalling.addMarshaller(new ExceptionMarshaller());
        JsonMarshalling.addMarshaller(new LoginMarshaller());
        JsonMarshalling.addMarshaller(new DateMarshaller());
        JsonMarshalling.addMarshaller(new PrimitiveMarshaller<String>(String.class));
        JsonMarshalling.addMarshaller(new PrimitiveMarshaller<Boolean>(Boolean.class));
        JsonMarshalling.addMarshaller(new PrimitiveMarshaller<Integer>(Integer.class));
        JsonMarshalling.addMarshaller(new PrimitiveMarshaller<Long>(Long.class));
        JsonMarshalling.addMarshaller(new PrimitiveMarshaller<Double>(Double.class));
    }
}

