/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.client.jaxrs.spi.marshallers;

import java.util.Map;
import net.sf.json.JSONObject;
import net.sf.json.JsonConfig;
import org.nuxeo.ecm.automation.client.jaxrs.spi.JsonMarshaller;

public class BeanMarshaller<T>
implements JsonMarshaller<T> {
    protected final Class<T> clazz;
    protected final String type;
    protected final JsonConfig config;

    public BeanMarshaller(Class<T> clazz) {
        this.clazz = clazz;
        this.type = clazz.getSimpleName().toLowerCase();
        this.config = new JsonConfig();
        this.config.setRootClass(clazz);
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public Class<T> getJavaType() {
        return this.clazz;
    }

    @Override
    public String getReference(T data) {
        JSONObject json = new JSONObject();
        this.write(json, data);
        return json.toString(2);
    }

    @Override
    public T read(JSONObject json) {
        return this.clazz.cast(JSONObject.toBean((JSONObject)json, (JsonConfig)this.config));
    }

    @Override
    public void write(JSONObject object, T value) {
        for (Object e : JSONObject.fromObject(value, (JsonConfig)this.config).entrySet()) {
            Map.Entry me = (Map.Entry)e;
            object.put(me.getKey(), me.getValue());
        }
    }
}

