/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.client.jaxrs.spi.marshallers;

import java.util.HashSet;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.nuxeo.ecm.automation.client.jaxrs.LoginInfo;
import org.nuxeo.ecm.automation.client.jaxrs.spi.JsonMarshaller;

public class LoginMarshaller
implements JsonMarshaller<LoginInfo> {
    @Override
    public String getType() {
        return "login";
    }

    @Override
    public Class<LoginInfo> getJavaType() {
        return LoginInfo.class;
    }

    @Override
    public String getReference(LoginInfo info) {
        throw new UnsupportedOperationException();
    }

    @Override
    public LoginInfo read(JSONObject json) {
        return LoginMarshaller.readLogin(json);
    }

    @Override
    public void write(JSONObject object, LoginInfo info) {
        object.put((Object)"username", (Object)info.getUsername());
        object.put((Object)"isAdministrator", (Object)info.isAdministrator());
        JSONArray groups = new JSONArray();
        for (String group : info.getGroups()) {
            groups.add((Object)group);
        }
        object.put((Object)"groups", (Object)groups);
    }

    protected static LoginInfo readLogin(JSONObject json) {
        String username = json.getString("username");
        String isAdmin = json.optString("isAdministrator", "false");
        JSONArray groups = json.optJSONArray("groups");
        HashSet<String> set = new HashSet<String>();
        if (groups != null) {
            int size = groups.size();
            for (int i = 0; i < size; ++i) {
                set.add(groups.getString(i));
            }
        }
        return new LoginInfo(username, set, Boolean.parseBoolean(isAdmin));
    }
}

