/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.client;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.nuxeo.ecm.automation.client.AutomationException;

public class RemoteException
extends AutomationException {
    private static final long serialVersionUID = 1L;
    protected final int status;
    protected final String type;
    protected final String info;
    protected final Throwable remoteCause;

    public RemoteException(int status, String type, String message, Throwable cause) {
        super(message, cause);
        this.status = status;
        this.type = type;
        this.info = RemoteException.extractInfo(cause);
        this.remoteCause = cause;
    }

    public RemoteException(int status, String type, String message, String info) {
        super(message);
        this.status = status;
        this.type = type;
        this.info = info;
        this.remoteCause = null;
    }

    public int getStatus() {
        return this.status;
    }

    public String getType() {
        return this.type;
    }

    protected static String extractInfo(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        return sw.getBuffer().toString();
    }

    public Throwable getRemoteCause() {
        return this.remoteCause;
    }

    public String getRemoteStackTrace() {
        return this.status + " - " + this.getMessage() + "\n" + this.info;
    }

    @Override
    public void printStackTrace(PrintStream s) {
        super.printStackTrace(s);
        s.println("====== Remote Stack Trace:");
        s.print(this.getRemoteStackTrace());
    }

    @Override
    public void printStackTrace(PrintWriter s) {
        super.printStackTrace(s);
        s.println("====== Remote Stack Trace:");
        s.print(this.getRemoteStackTrace());
    }

    public static RemoteException wrap(Throwable t) {
        return RemoteException.wrap(t, 500);
    }

    public static RemoteException wrap(Throwable t, int status) {
        return RemoteException.wrap(t.getMessage(), t, status);
    }

    public static RemoteException wrap(String message, Throwable t) {
        return RemoteException.wrap(message, t, 500);
    }

    public static RemoteException wrap(String message, Throwable t, int status) {
        RemoteException e = new RemoteException(status, t.getClass().getName(), message, t);
        e.initCause(t);
        return e;
    }
}

