/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.client.jaxrs.spi;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.automation.client.AsyncCallback;
import org.nuxeo.ecm.automation.client.OperationRequest;
import org.nuxeo.ecm.automation.client.jaxrs.spi.JavaSession;
import org.nuxeo.ecm.automation.client.model.DateUtils;
import org.nuxeo.ecm.automation.client.model.OperationDocumentation;
import org.nuxeo.ecm.automation.client.model.OperationInput;

public class JavaOperationRequest
implements OperationRequest {
    protected final OperationDocumentation op;
    protected final JavaSession session;
    protected final Map<String, Object> params;
    protected final Map<String, Object> ctx;
    protected final Map<String, String> headers;
    protected OperationInput input;

    public JavaOperationRequest(JavaSession session, OperationDocumentation op) {
        this(session, op, new HashMap<String, Object>());
    }

    public JavaOperationRequest(JavaSession session, OperationDocumentation op, Map<String, Object> ctx) {
        this.session = session;
        this.op = op;
        this.params = new HashMap<String, Object>();
        this.headers = new HashMap<String, String>();
        this.ctx = ctx;
    }

    @Override
    public JavaSession getSession() {
        return this.session;
    }

    protected final boolean acceptInput(String type) {
        int size = this.op.signature.length;
        for (int i = 0; i < size; i += 2) {
            if ("void".equals(this.op.signature[i])) {
                return true;
            }
            if (!type.equals(this.op.signature[i])) continue;
            return true;
        }
        return false;
    }

    protected final void checkInput(String type) {
        if (!this.acceptInput(type)) {
            throw new IllegalArgumentException("Input not supported: " + type);
        }
    }

    public List<String> getParamNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (OperationDocumentation.Param param : this.op.params) {
            result.add(param.name);
        }
        return result;
    }

    public OperationDocumentation.Param getParam(String key) {
        for (OperationDocumentation.Param param : this.op.params) {
            if (!key.equals(param.name)) continue;
            return param;
        }
        return null;
    }

    @Override
    public OperationRequest setInput(OperationInput input) {
        if (input == null) {
            this.checkInput("void");
        } else {
            this.checkInput(input.getInputType());
        }
        this.input = input;
        return this;
    }

    @Override
    public OperationInput getInput() {
        return this.input;
    }

    @Override
    public String getUrl() {
        return this.session.getClient().getBaseUrl() + this.op.url;
    }

    @Override
    public OperationRequest set(String key, Object value) {
        OperationDocumentation.Param param = this.getParam(key);
        if (param == null) {
            throw new IllegalArgumentException("No such parameter '" + key + "' for operation " + this.op.id + ".\n\tAvailable params: " + this.getParamNames());
        }
        if (value == null) {
            this.params.remove(key);
            return this;
        }
        if (value.getClass() == Date.class) {
            this.params.put(key, DateUtils.formatDate((Date)value));
        } else {
            this.params.put(key, value.toString());
        }
        return this;
    }

    @Override
    public OperationRequest setContextProperty(String key, Object value) {
        this.ctx.put(key, value != null ? value.toString() : null);
        return this;
    }

    @Override
    public Map<String, Object> getContextParameters() {
        return this.ctx;
    }

    @Override
    public Map<String, Object> getParameters() {
        return this.params;
    }

    @Override
    public Object execute() throws Exception {
        return this.session.execute(this);
    }

    @Override
    public void execute(AsyncCallback<Object> cb) {
        this.session.execute(this, cb);
    }

    @Override
    public OperationRequest setHeader(String key, String value) {
        this.headers.put(key, value);
        return this;
    }

    @Override
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @Override
    public OperationDocumentation getOperation() {
        return this.op;
    }
}

