/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.client;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import org.nuxeo.ecm.automation.client.AdapterFactory;
import org.nuxeo.ecm.automation.client.Session;

public class AdapterManager {
    protected final Set<AdapterFactory<?>> factories = new HashSet();

    public <T> T getAdapter(Session session, Class<T> adapterType) {
        for (AdapterFactory<?> f : this.factories) {
            if (!this.factoryAccept(f, adapterType)) continue;
            AdapterFactory<?> tFactory = f;
            return adapterType.cast(tFactory.getAdapter(session, adapterType));
        }
        return null;
    }

    protected boolean factoryAccept(AdapterFactory<?> factory, Class<?> adapterType) {
        Class clazz;
        ParameterizedType itf = (ParameterizedType)factory.getClass().getGenericInterfaces()[0];
        Type type = itf.getActualTypeArguments()[0];
        if (type instanceof Class) {
            clazz = (Class)type;
        } else if (type instanceof ParameterizedType) {
            clazz = (Class)((ParameterizedType)type).getRawType();
        } else {
            throw new UnsupportedOperationException("Don't know how to handle " + type.getClass());
        }
        return clazz.isAssignableFrom(adapterType);
    }

    public void registerAdapter(AdapterFactory<?> factory) {
        this.factories.add(factory);
    }

    public void clear() {
        this.factories.clear();
    }
}

