/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.client.jaxrs.spi.auth;

import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import org.nuxeo.ecm.automation.client.jaxrs.spi.Connector;
import org.nuxeo.ecm.automation.client.jaxrs.spi.Request;
import org.nuxeo.ecm.automation.client.jaxrs.spi.RequestInterceptor;
import org.nuxeo.ecm.automation.client.jaxrs.util.Base64;

public class BasicAuthInterceptor
extends RequestInterceptor {
    protected String token;

    public BasicAuthInterceptor(String username, String password) {
        this.setAuth(username, password);
    }

    public void setAuth(String username, String password) {
        String info = username + ":" + password;
        this.token = "Basic " + Base64.encode(info);
    }

    @Override
    public void processRequest(Request request, Connector connector) {
        request.put("Authorization", this.token);
    }

    @Override
    public ClientResponse handle(ClientRequest cr) throws ClientHandlerException {
        if (!cr.getHeaders().containsKey((Object)"Authorization")) {
            cr.getHeaders().add((Object)"Authorization", (Object)this.token);
        }
        return this.getNext().handle(cr);
    }
}

