/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.client.rest.api;

import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.AutomationException;
import org.nuxeo.ecm.automation.client.rest.api.RequestType;
import org.nuxeo.ecm.automation.client.rest.api.RestResponse;

public class RestRequest {
    protected final WebResource service;
    protected final String path;
    protected RequestType requestType = RequestType.GET;
    protected String data;
    protected String repositoryName;
    protected List<String> schemas = new ArrayList<String>();
    protected Map<String, Object> headers = new HashMap<String, Object>();
    protected MultivaluedMap<String, String> queryParams = new MultivaluedMapImpl();

    public RestRequest(WebResource service, String path) {
        this.service = service;
        this.path = path;
    }

    public RestRequest requestType(RequestType requestType) {
        this.requestType = requestType;
        return this;
    }

    public RestRequest data(String data) {
        this.data = data;
        return this;
    }

    public RestRequest repositoryName(String repositoryName) {
        this.repositoryName = repositoryName;
        return this;
    }

    public RestRequest schema(String schema) {
        this.schemas.add(schema);
        return this;
    }

    public RestRequest schemas(List<String> schemas) {
        this.schemas.addAll(schemas);
        return this;
    }

    public RestRequest header(String key, Object value) {
        this.headers.put(key, value);
        return this;
    }

    public RestRequest headers(Map<String, Object> headers) {
        this.headers.putAll(headers);
        return this;
    }

    public RestRequest queryParam(String key, String value) {
        this.queryParams.add((Object)key, (Object)value);
        return this;
    }

    public RestRequest queryParams(MultivaluedMap<String, String> queryParams) {
        this.queryParams.putAll(queryParams);
        return this;
    }

    public String getPath() {
        return this.path;
    }

    public RequestType getRequestType() {
        return this.requestType;
    }

    public String getData() {
        return this.data;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public List<String> getSchemas() {
        return this.schemas;
    }

    public Map<String, Object> getHeaders() {
        return this.headers;
    }

    public MultivaluedMap<String, String> getQueryParams() {
        return this.queryParams;
    }

    public RestResponse execute() {
        ClientResponse response;
        WebResource wr = this.service;
        if (!StringUtils.isBlank((String)this.repositoryName)) {
            wr = wr.path("repo").path(this.repositoryName);
        }
        wr = wr.path(this.path);
        if (this.queryParams != null && !this.queryParams.isEmpty()) {
            wr = wr.queryParams(this.queryParams);
        }
        WebResource.Builder builder = wr.accept(new String[]{"application/json"});
        for (Map.Entry<String, Object> header : this.headers.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        if (!this.schemas.isEmpty()) {
            String documentPropertiesHeader = StringUtils.join(this.schemas, (String)",");
            builder.header("X-NXDocumentProperties", (Object)documentPropertiesHeader);
        }
        if (this.requestType == RequestType.POSTREQUEST) {
            builder.header("Content-Type", (Object)"application/json+nxrequest; charset=UTF-8");
        } else {
            builder.header("Content-Type", (Object)"application/json+nxentity");
        }
        switch (this.requestType) {
            case GET: {
                response = (ClientResponse)builder.get(ClientResponse.class);
                break;
            }
            case POST: 
            case POSTREQUEST: {
                response = (ClientResponse)builder.post(ClientResponse.class, (Object)this.data);
                break;
            }
            case PUT: {
                response = (ClientResponse)builder.put(ClientResponse.class, (Object)this.data);
                break;
            }
            case DELETE: {
                response = (ClientResponse)builder.delete(ClientResponse.class, (Object)this.data);
                break;
            }
            default: {
                throw new AutomationException();
            }
        }
        return new RestResponse(response);
    }
}

