/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.jaxrs.io;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import org.codehaus.jackson.JsonEncoding;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.webengine.WebException;

public abstract class EntityWriter<T>
implements MessageBodyWriter<T> {
    @Context
    protected JsonFactory factory;

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        if (genericType instanceof ParameterizedType) {
            return false;
        }
        ParameterizedType ptype = (ParameterizedType)this.getClass().getGenericSuperclass();
        Type[] ts = ptype.getActualTypeArguments();
        Class c = (Class)ts[0];
        return c.isAssignableFrom(type);
    }

    public long getSize(T t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(T entity, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        try {
            this.writeEntity(this.factory.createJsonGenerator(entityStream, JsonEncoding.UTF8), entity);
        }
        catch (ClientException e) {
            throw WebException.wrap((Throwable)e);
        }
    }

    public void writeEntity(JsonGenerator jg, T item) throws IOException, ClientException {
        jg.writeStartObject();
        jg.writeStringField("entity-type", this.getEntityType());
        this.writeEntityBody(jg, item);
        jg.writeEndObject();
        jg.flush();
    }

    protected abstract void writeEntityBody(JsonGenerator var1, T var2) throws IOException, ClientException;

    protected abstract String getEntityType();
}

