/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.jaxrs.io;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Map;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.JsonEncoding;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.nuxeo.ecm.automation.core.util.PaginableRecordSet;
import org.nuxeo.ecm.automation.core.util.RecordSet;

@Provider
@Produces(value={"application/json+nxentity", "application/json"})
public class JsonRecordSetWriter
implements MessageBodyWriter<RecordSet> {
    protected static Log log = LogFactory.getLog(JsonRecordSetWriter.class);
    @Context
    JsonFactory factory;

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        boolean canUse = RecordSet.class.isAssignableFrom(type);
        return canUse;
    }

    public long getSize(RecordSet t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(RecordSet records, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream out) throws IOException, WebApplicationException {
        try {
            this.writeRecords(out, records);
        }
        catch (Exception e) {
            log.error((Object)"Failed to serialize recordset", (Throwable)e);
            throw new WebApplicationException(500);
        }
    }

    protected void writeRecords(OutputStream out, RecordSet records) throws Exception {
        JsonGenerator jg = this.factory.createJsonGenerator(out, JsonEncoding.UTF8);
        jg.writeStartObject();
        jg.writeStringField("entity-type", "recordSet");
        if (records instanceof PaginableRecordSet) {
            PaginableRecordSet pRecord = (PaginableRecordSet)records;
            jg.writeBooleanField("isPaginable", true);
            jg.writeNumberField("resultsCount", pRecord.getResultsCount());
            jg.writeNumberField("pageSize", pRecord.getPageSize());
            jg.writeNumberField("maxPageSize", pRecord.getMaxPageSize());
            jg.writeNumberField("currentPageSize", pRecord.getCurrentPageSize());
            jg.writeNumberField("currentPageIndex", pRecord.getCurrentPageIndex());
            jg.writeNumberField("numberOfPages", pRecord.getNumberOfPages());
            jg.writeBooleanField("isPreviousPageAvailable", pRecord.isPreviousPageAvailable());
            jg.writeBooleanField("isNextPageAvailable", pRecord.isNextPageAvailable());
            jg.writeBooleanField("isLasPageAvailable", pRecord.isLastPageAvailable());
            jg.writeBooleanField("isSortable", pRecord.isSortable());
            jg.writeBooleanField("hasError", pRecord.hasError());
            jg.writeStringField("errorMessage", pRecord.getErrorMessage());
        }
        jg.writeArrayFieldStart("entries");
        for (Map entry : records) {
            jg.writeObject((Object)entry);
        }
        jg.writeEndArray();
        jg.writeEndObject();
        jg.flush();
    }
}

