/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.io.services.enricher;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.el.ELContext;
import javax.el.ExpressionFactory;
import javax.ws.rs.core.HttpHeaders;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.jboss.el.ExpressionFactoryImpl;
import org.nuxeo.common.utils.StringUtils;
import org.nuxeo.ecm.automation.io.services.enricher.ContentEnricher;
import org.nuxeo.ecm.automation.io.services.enricher.ContentEnricherDescriptor;
import org.nuxeo.ecm.automation.io.services.enricher.ContentEnricherService;
import org.nuxeo.ecm.automation.io.services.enricher.RestEvaluationContext;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.platform.actions.ActionContext;
import org.nuxeo.ecm.platform.actions.ELActionContext;
import org.nuxeo.ecm.platform.actions.ejb.ActionManager;
import org.nuxeo.ecm.platform.el.ExpressionContext;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class ContentEnricherServiceImpl
extends DefaultComponent
implements ContentEnricherService {
    public static final String NXCONTENT_CATEGORY_HEADER = "X-NXContext-Category";
    protected static final Log log = LogFactory.getLog(ContentEnricherServiceImpl.class);
    public static final String ENRICHER = "enricher";
    private Map<String, ContentEnricherDescriptor> descriptorRegistry = new ConcurrentHashMap<String, ContentEnricherDescriptor>();

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (ENRICHER.equals(extensionPoint)) {
            ContentEnricherDescriptor cd = (ContentEnricherDescriptor)contribution;
            this.descriptorRegistry.put(cd.name, cd);
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (ENRICHER.equals(extensionPoint)) {
            ContentEnricherDescriptor cd = (ContentEnricherDescriptor)contribution;
            if (this.descriptorRegistry.containsKey(cd.name)) {
                this.descriptorRegistry.remove(cd.name);
            }
        }
    }

    @Override
    public List<ContentEnricher> getEnrichers(String category, RestEvaluationContext context) {
        ArrayList<ContentEnricher> result = new ArrayList<ContentEnricher>();
        for (ContentEnricherDescriptor descriptor : this.getEnricherDescriptors(category, context)) {
            ContentEnricher contentEnricher = descriptor.getContentEnricher();
            result.add(contentEnricher);
        }
        return result;
    }

    private List<ContentEnricherDescriptor> getEnricherDescriptors(String category, RestEvaluationContext context) {
        ArrayList<ContentEnricherDescriptor> result = new ArrayList<ContentEnricherDescriptor>();
        for (Map.Entry<String, ContentEnricherDescriptor> entry : this.descriptorRegistry.entrySet()) {
            ContentEnricherDescriptor descriptor = entry.getValue();
            if (!descriptor.categories.contains(category)) continue;
            result.add(descriptor);
        }
        return result;
    }

    @Override
    public void writeContext(JsonGenerator jg, RestEvaluationContext ec) throws JsonGenerationException, IOException, ClientException {
        for (String category : this.getCategoriesToActivate(ec)) {
            for (ContentEnricherDescriptor descriptor : this.getEnricherDescriptors(category, ec)) {
                ContentEnricher enricher;
                if (!this.evaluateFilter(ec, descriptor) || (enricher = descriptor.getContentEnricher()) == null) continue;
                jg.writeFieldName(descriptor.name);
                enricher.enrich(jg, ec);
            }
        }
    }

    private boolean evaluateFilter(RestEvaluationContext ec, ContentEnricherDescriptor descriptor) {
        for (String filterId : descriptor.filterIds) {
            ActionManager as = (ActionManager)Framework.getLocalService(ActionManager.class);
            if (as.checkFilter(filterId, this.createActionContext(ec))) continue;
            return false;
        }
        return true;
    }

    private ActionContext createActionContext(RestEvaluationContext ec) {
        ELActionContext actionContext = new ELActionContext((ELContext)new ExpressionContext(), (ExpressionFactory)new ExpressionFactoryImpl());
        CoreSession session = ec.getDocumentModel().getCoreSession();
        actionContext.setDocumentManager(session);
        actionContext.setCurrentPrincipal((NuxeoPrincipal)session.getPrincipal());
        actionContext.setCurrentDocument(ec.getDocumentModel());
        return actionContext;
    }

    private List<String> getCategoriesToActivate(RestEvaluationContext ec) {
        HttpHeaders headers = ec.getHeaders();
        if (headers != null) {
            List requestHeader = headers.getRequestHeader(NXCONTENT_CATEGORY_HEADER);
            if (requestHeader != null && !requestHeader.isEmpty()) {
                return Arrays.asList(StringUtils.split((String)((String)requestHeader.get(0)), (char)',', (boolean)true));
            }
            return new ArrayList<String>(0);
        }
        return new ArrayList<String>(0);
    }
}

