/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.jaxrs.io;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import javax.ws.rs.core.MediaType;
import org.codehaus.jackson.JsonGenerator;
import org.nuxeo.ecm.automation.core.util.Paginable;
import org.nuxeo.ecm.automation.jaxrs.io.EntityWriter;
import org.nuxeo.ecm.core.api.ClientException;

public abstract class EntityListWriter<T>
extends EntityWriter<List<T>> {
    @Override
    protected abstract String getEntityType();

    protected abstract void writeItem(JsonGenerator var1, T var2) throws ClientException, IOException;

    @Override
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        if (!List.class.isAssignableFrom(type)) {
            return false;
        }
        if (genericType instanceof ParameterizedType) {
            ParameterizedType paramType = (ParameterizedType)genericType;
            Type actualTypeArguments = paramType.getActualTypeArguments()[0];
            if (type == null) {
                throw new RuntimeException("Invalid class parameter type.");
            }
            return ((Class)actualTypeArguments).isAssignableFrom(this.getItemClass());
        }
        return false;
    }

    private Class<?> getItemClass() {
        return (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
    }

    @Override
    protected void writeEntityBody(JsonGenerator jg, List<T> list) throws IOException, ClientException {
        this.writePaginableHeader(jg, list);
        this.writeHeader(jg, list);
        jg.writeArrayFieldStart("entries");
        for (T item : list) {
            this.writeItem(jg, item);
        }
        jg.writeEndArray();
    }

    protected void writePaginableHeader(JsonGenerator jg, List<T> list) throws IOException {
        if (list instanceof Paginable) {
            Paginable paginable = (Paginable)list;
            jg.writeBooleanField("isPaginable", true);
            jg.writeNumberField("resultsCount", paginable.getResultsCount());
            jg.writeNumberField("pageSize", paginable.getPageSize());
            jg.writeNumberField("maxPageSize", paginable.getMaxPageSize());
            jg.writeNumberField("currentPageSize", paginable.getCurrentPageSize());
            jg.writeNumberField("currentPageIndex", paginable.getCurrentPageIndex());
            jg.writeNumberField("numberOfPages", paginable.getNumberOfPages());
            jg.writeBooleanField("isPreviousPageAvailable", paginable.isPreviousPageAvailable());
            jg.writeBooleanField("isNextPageAvailable", paginable.isNextPageAvailable());
            jg.writeBooleanField("isLastPageAvailable", paginable.isLastPageAvailable());
            jg.writeBooleanField("isSortable", paginable.isSortable());
            jg.writeBooleanField("hasError", paginable.hasError());
            jg.writeStringField("errorMessage", paginable.getErrorMessage());
            if (paginable.hasAggregateSupport() && paginable.getAggregates() != null && !paginable.getAggregates().isEmpty()) {
                jg.writeObjectField("aggregations", (Object)paginable.getAggregates());
            }
        }
    }

    protected void writeHeader(JsonGenerator jg, List<T> list) throws IOException {
    }
}

